<div x-data="indexAppointments" wire:init="init">
    {{-- BREADCRUMB --}}
    {{-- <x-slot name="header">
        <div class="flex">
            <!-- Breadcrumb -->
            <nav class="flex px-5 py-3 text-gray-700 border border-gray-200 rounded-lg bg-gray-50 dark:bg-gray-800 dark:border-gray-700"
                aria-label="Breadcrumb">
                <ol class="inline-flex items-center space-x-1 md:space-x-2 rtl:space-x-reverse">
                    <li class="inline-flex items-center">
                        <a href="{{ route('reports.index') }}"
                            class="inline-flex items-center text-sm font-medium text-gray-700 hover:text-primary-600 dark:text-gray-400 dark:hover:text-white">
                            <svg class="w-3 h-3 me-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                fill="currentColor" viewBox="0 0 20 20">
                                <path
                                    d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2a1 1 0 0 0 1.414 1.414L2 10.414V18a2 2 0 0 0 2 2h3a1 1 0 0 0 1-1v-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4a1 1 0 0 0 1 1h3a2 2 0 0 0 2-2v-7.586l.293.293a1 1 0 0 0 1.414-1.414Z" />
                            </svg>
                            @lang('navigation.reports')
                        </a>
                    </li>
                    <li aria-current="page">
                        <div class="flex items-center">
                            <svg class="w-3 h-3 mx-1 text-gray-400 rtl:rotate-180" aria-hidden="true"
                                xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2" d="m1 9 4-4-4-4" />
                            </svg>
                            <span class="text-sm font-medium text-gray-500 ms-1 md:ms-2 dark:text-gray-400">
                                @lang('logs.logs')
                            </span>
                        </div>
                    </li>
                </ol>
            </nav>
        </div>
    </x-slot> --}}
    {{-- BREADCRUMB END --}}

    <div class="my-4">
        <h2 class="text-4xl font-extrabold dark:text-white">
            @lang('visitor-management::visit-appointments.page.heading')
        </h2>
        <p class="my-4 text-lg text-gray-500">
            @lang('visitor-management::visit-appointments.page.description')
        </p>
    </div>
    <div class="relative bg-white shadow-md dark:bg-gray-800 sm:rounded-lg">
        <div class="p-4">
            <div class="flex flex-col items-center justify-between space-y-3 md:flex-row md:space-y-0 md:space-x-4">
                {{-- SEARCH --}}
                <div class="w-full md:w-1/2">
                    <label for="search" class="invisible">
                        @lang('visitor-management::visit-appointments.search-label.appointments')
                    </label>
                    <div class="flex items-center">
                        <div class="relative w-full">
                            <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                <svg aria-hidden="true" class="w-5 h-5 text-gray-500 dark:text-gray-400"
                                    fill="currentColor" viewbox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd"
                                        d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z"
                                        clip-rule="evenodd" />
                                </svg>
                            </div>
                            <input wire:model.live.debounce.500ms="search" type="text" id="search"
                                class="block w-full p-2 pl-10 text-sm text-gray-900 border border-gray-300 rounded-lg bg-gray-50 focus:ring-primary-500 focus:border-primary-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-appointments.placeholder.appointments')" required="" />
                        </div>
                    </div>
                </div>
                <div
                    class="flex flex-col items-stretch justify-end flex-shrink-0 w-full space-y-2 md:w-auto md:flex-row md:space-y-0 md:items-center md:space-x-3">
                    <div class="flatpickr relative">
                        <label for="filter-startdate"
                            class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                            @lang('visitor-management::visit-appointments.search-label.start-date')
                        </label>
                        <div wire:ignore>
                            <input type="text" id="filter-startdate" wire:model.live.debounce.500ms="filterStartDate"
                                class="flatpickr-input bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                        </div>
                    </div>
                    <div>
                        <label for="filter-enddate"
                            class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                            @lang('visitor-management::visit-appointments.search-label.end-date')
                        </label>
                        <div wire:ignore>
                            <input type="text" readonly="readonly" id="filter-enddate"
                                wire:model.live.debounce.500ms="filterEndDate"
                                class="flatpickr-input bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                        </div>
                    </div>
                </div>
                <div
                    class="flex flex-col items-stretch justify-end flex-shrink-0 w-full space-y-2 md:w-auto md:flex-row md:space-y-0 md:items-center md:space-x-3">
                    <button x-on:click="$dispatch('show-create-appointment-modal')" type="button"
                        class="flex items-center justify-center px-4 py-2 text-sm font-medium text-white rounded-lg bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 focus:outline-none dark:focus:ring-primary-800">
                        <svg class="h-3.5 w-3.5 mr-2" fill="currentColor" viewbox="0 0 20 20"
                            xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                            <path clip-rule="evenodd" fill-rule="evenodd"
                                d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z" />
                        </svg>
                        @lang('visitor-management::visit-appointments.action.create')
                    </button>
                </div>
            </div>
            <hr class="my-4">
            {{-- APPOINTMENT FILTER --}}
            <div
                class="flex flex-col items-stretch flex-shrink-0 w-full md:w-auto md:flex-row md:space-y-0 md:items-center md:space-x-3">

                <div>
                    <x-dropdown align="right" width="60">
                        <x-slot name="trigger">
                            <label class="invisible">1
                                @lang('visitor-management::visit-appointments.search-label.visit-group')
                            </label>
                            <button
                                class="flex items-center justify-center w-full px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-lg md:w-auto focus:outline-none hover:bg-gray-100 hover:text-primary-700 focus:z-10 focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700"
                                type="button">
                                <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true"
                                    class="w-4 h-4 mr-2 text-gray-400" viewbox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd"
                                        d="M3 3a1 1 0 011-1h12a1 1 0 011 1v3a1 1 0 01-.293.707L12 11.414V15a1 1 0 01-.293.707l-2 2A1 1 0 018 17v-5.586L3.293 6.707A1 1 0 013 6V3z"
                                        clip-rule="evenodd" />
                                </svg>
                                @lang('visitor-management::visit-appointments.search-label.visit-group')
                                <span
                                    class="bg-primary-100 text-primary-800 text-xs font-medium ml-2 px-2.5 py-0.5 rounded dark:bg-primary-900 dark:text-primary-300">
                                    {{ count($filterVisitTypeGroups) }}
                                </span>
                                <svg class="-mr-1 ml-1.5 w-5 h-5" fill="currentColor" viewbox="0 0 20 20"
                                    xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                    <path clip-rule="evenodd" fill-rule="evenodd"
                                        d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" />
                                </svg>
                            </button>
                        </x-slot>

                        <x-slot name="content">
                            <div class="z-10 w-48 p-3 bg-white rounded-lg dark:bg-gray-700">
                                <h6 class="mb-3 text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.search-caption.visit-group')
                                </h6>
                                <ul class="space-y-2 overflow-y-scroll text-sm max-h-72">
                                    @forelse ($visitTypeGroups as $visitTypeGroup)
                                        <li class="flex items-center p-1">
                                            <input id="visit_types_{{ $visitTypeGroup }}" type="checkbox"
                                                value="{{ $visitTypeGroup }}" wire:model.live="filterVisitTypeGroups"
                                                class="w-4 h-4 bg-gray-100 border-gray-300 rounded text-primary-600 focus:ring-primary-500 dark:focus:ring-primary-600 dark:ring-offset-gray-700 focus:ring-2 dark:bg-gray-600 dark:border-gray-500" />
                                            <label for="visit_types_{{ $visitTypeGroup }}"
                                                class="ml-2 text-sm font-medium text-gray-900 dark:text-gray-100">
                                                @lang('visitor-management::global.visit-group.' . $visitTypeGroup)
                                            </label>
                                        </li>
                                    @empty
                                        <li class="flex items-center">
                                            <label for="apple"
                                                class="ml-2 text-sm font-medium text-gray-900 dark:text-gray-100">
                                                @lang('visitor-management::visit-appointments.info.no-visit-types-found')
                                            </label>
                                        </li>
                                    @endforelse
                                </ul>
                            </div>
                        </x-slot>
                    </x-dropdown>
                </div>
                <div>
                    {{-- VISIT TYPE --}}
                    <x-dropdown align="right" width="60">
                        <x-slot name="trigger">
                            <label class="invisible">
                                @lang('visitor-management::visit-appointments.search-label.visit-type')
                            </label>
                            <button
                                class="flex items-center justify-center w-full px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-lg md:w-auto focus:outline-none hover:bg-gray-100 hover:text-primary-700 focus:z-10 focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700"
                                type="button">
                                <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true"
                                    class="w-4 h-4 mr-2 text-gray-400" viewbox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd"
                                        d="M3 3a1 1 0 011-1h12a1 1 0 011 1v3a1 1 0 01-.293.707L12 11.414V15a1 1 0 01-.293.707l-2 2A1 1 0 018 17v-5.586L3.293 6.707A1 1 0 013 6V3z"
                                        clip-rule="evenodd" />
                                </svg>
                                @lang('visitor-management::visit-appointments.search-label.visit-type')
                                <span
                                    class="bg-primary-100 text-primary-800 text-xs font-medium ml-2 px-2.5 py-0.5 rounded dark:bg-primary-900 dark:text-primary-300">
                                    {{ count($filterVisitTypes) }}
                                </span>
                                <svg class="-mr-1 ml-1.5 w-5 h-5" fill="currentColor" viewbox="0 0 20 20"
                                    xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                    <path clip-rule="evenodd" fill-rule="evenodd"
                                        d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" />
                                </svg>
                            </button>
                        </x-slot>

                        <x-slot name="content">
                            <div class="z-10 w-48 p-3 bg-white rounded-lg dark:bg-gray-700">
                                <h6 class="mb-3 text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.search-caption.visit-type')
                                </h6>
                                <ul class="space-y-2 overflow-y-scroll text-sm max-h-72">
                                    @forelse ($visitTypes as $visitType)
                                        <li class="flex items-center p-1">
                                            <input id="visit_types_{{ $visitType->id }}" type="checkbox"
                                                value="{{ $visitType->id }}" wire:model.live="filterVisitTypes"
                                                class="w-4 h-4 bg-gray-100 border-gray-300 rounded text-primary-600 focus:ring-primary-500 dark:focus:ring-primary-600 dark:ring-offset-gray-700 focus:ring-2 dark:bg-gray-600 dark:border-gray-500" />
                                            <label for="visit_types_{{ $visitType->id }}"
                                                class="ml-2 text-sm font-medium text-gray-900 dark:text-gray-100">
                                                @lang('visitor-management::visit-types.identifier.' . $visitType->identifier)
                                            </label>
                                        </li>
                                    @empty
                                        <li class="flex items-center">
                                            <label for="apple"
                                                class="ml-2 text-sm font-medium text-gray-900 dark:text-gray-100">
                                                @lang('visitor-management::visit-appointments.info.no-visit-types-found')
                                            </label>
                                        </li>
                                    @endforelse
                                </ul>
                            </div>
                        </x-slot>
                    </x-dropdown>
                    {{-- FILTER VISIT TYPE END --}}
                </div>

            </div>
        </div>
        @if (count($appointments) > 0)
            <div class="overflow-x-auto">
                <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
                    <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                        <tr>
                            <th scope="col" class="px-4 py-3">
                                @lang('globals::global.caption.id')
                            </th>
                            <th scope="col" class="px-4 py-3">
                                @lang('visitor-management::visit-appointments.caption.start-date')
                            </th>
                            <th scope="col" class="px-4 py-3">
                                @lang('visitor-management::visit-appointments.caption.subject')
                            </th>
                            <th scope="col" class="px-4 py-3">
                                @lang('visitor-management::visit-appointments.caption.visit-type')
                            </th>
                            <th scope="col" class="px-4 py-3">
                                @lang('visitor-management::visit-appointments.caption.reference-number')
                            </th>
                            <th scope="col" class="px-4 py-3">
                                @lang('visitor-management::visit-appointments.caption.token')
                            </th>
                            <th scope="col" class="px-4 py-3">
                                @lang('globals::global.caption.action')
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($appointments as $appointment)
                            <tr id="appointment-{{ $appointment->id }}" class="border-b dark:border-gray-700">
                                <th scope="row"
                                    class="px-4 py-3 font-medium text-gray-900 whitespace-nowrap dark:text-white">
                                    {{ $appointment->id }}
                                </th>
                                <td class="px-4 py-3">
                                    {{ $appointment->valid_from->format(__('globals::global.datetime.format')) }}
                                </td>
                                <td class="px-4 py-3">
                                    {{ $appointment->subject }}
                                </td>
                                <td class="px-4 py-3">
                                    @lang('visitor-management::visit-types.identifier.' . $appointment->visitReason->visitType->identifier)
                                </td>
                                <td class="px-4 py-3">
                                    {{ $appointment->order_number }}
                                </td>
                                <td class="px-4 py-3">
                                    {{ $appointment->token }}
                                </td>
                                <td class="flex py-3">
                                    <button data-tippy-content="{{ __('globals::global.action.edit') }}" type="button"
                                        x-on:click="$dispatch('show-edit-appointment-modal', { appointment: @js($appointment) })"
                                        class="inline-flex items-center p-0.5 text-sm font-medium text-center text-gray-500 hover:text-gray-800 rounded-lg focus:outline-none dark:text-gray-400 dark:hover:text-gray-100">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                            stroke-width="1.5" stroke="currentColor" class="w-5 h-5">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                                        </svg>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            @if ($appointments->lastPage() > 1)
                <div class="p-4">
                    {{ $appointments->links() }}
                </div>
            @endif
        @else
            <div class="max-w-screen-xl px-4 py-8 mx-auto lg:py-16 lg:px-6">
                <div class="max-w-screen-sm mx-auto text-center">
                    <div class="flex justify-center">
                        <svg aria-hidden="true"
                            class="w-24 h-24 mb-4 font-extrabold tracking-tight lg:text-9xl text-primary-600 dark:text-primary-500"
                            fill="currentColor" viewbox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z"
                                clip-rule="evenodd" />
                        </svg>
                    </div>
                    <p class="mb-4 text-3xl font-bold tracking-tight text-gray-900 md:text-4xl dark:text-white">
                        @lang('visitor-management::visit-appointments.info.not-found')
                    </p>
                    @if (count($appointments) > 0)
                        <p class="mb-4 text-lg font-light text-gray-500 dark:text-gray-400">
                            @lang('visitor-management::visit-appointments.search-result.not-found')
                        </p>
                    @else
                        <p class="mb-4 text-lg font-light text-gray-500 dark:text-gray-400">
                            @lang('visitor-management::visit-appointments.info.not-found-description')
                        </p>
                    @endif
                </div>
            </div>
        @endif
    </div>
    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('indexAppointments', () => ({
                init() {
                    let datepickerStart = flatpickr("#filter-startdate", {
                        locale: @js(app()->getLocale()),
                        dateFormat: "Y-m-d",
                        altInput: true,
                        altFormat: @js(__('globals::global.date.format')),
                    });

                    let datepickerEnd = flatpickr("#filter-enddate", {
                        locale: @js(app()->getLocale()),
                        dateFormat: "Y-m-d",
                        altInput: true,
                        altFormat: @js(__('globals::global.date.format')),
                    });
                }
            }));
        });
    </script>
</div>
