<div x-data="createAppointment" x-cloak x-show="show" id="createAppointmentModal" tabindex="-1"
    x-on:show-create-appointment-modal.window="showModal($event)" x-on:appointment-created.window="created($event)"
    x-on:appointment-pagination-updated="paginationUpdated"
    class="fixed top-0 left-0 right-0 z-50 flex items-center justify-center w-full h-screen overflow-x-hidden overflow-y-auto md:inset-0 md:h-full">
    <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75"></div>
    <div class="relative w-full h-full p-4 sm:max-w-5xl md:h-auto">
        <!-- Modal content -->
        <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
            <!-- Modal header -->
            <div class="flex items-center justify-between pb-4 mb-4 border-b rounded-t sm:mb-5 dark:border-gray-600">

                <div class="flex items-center space-x-2 text-gray-900 dark:text-white">
                    {{-- calendar-date-range --}}
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6">
                        <path
                            d="M12 11.993a.75.75 0 0 0-.75.75v.006c0 .414.336.75.75.75h.006a.75.75 0 0 0 .75-.75v-.006a.75.75 0 0 0-.75-.75H12ZM12 16.494a.75.75 0 0 0-.75.75v.005c0 .414.335.75.75.75h.005a.75.75 0 0 0 .75-.75v-.005a.75.75 0 0 0-.75-.75H12ZM8.999 17.244a.75.75 0 0 1 .75-.75h.006a.75.75 0 0 1 .75.75v.006a.75.75 0 0 1-.75.75h-.006a.75.75 0 0 1-.75-.75v-.006ZM7.499 16.494a.75.75 0 0 0-.75.75v.005c0 .414.336.75.75.75h.005a.75.75 0 0 0 .75-.75v-.005a.75.75 0 0 0-.75-.75H7.5ZM13.499 14.997a.75.75 0 0 1 .75-.75h.006a.75.75 0 0 1 .75.75v.005a.75.75 0 0 1-.75.75h-.006a.75.75 0 0 1-.75-.75v-.005ZM14.25 16.494a.75.75 0 0 0-.75.75v.006c0 .414.335.75.75.75h.005a.75.75 0 0 0 .75-.75v-.006a.75.75 0 0 0-.75-.75h-.005ZM15.75 14.995a.75.75 0 0 1 .75-.75h.005a.75.75 0 0 1 .75.75v.006a.75.75 0 0 1-.75.75H16.5a.75.75 0 0 1-.75-.75v-.006ZM13.498 12.743a.75.75 0 0 1 .75-.75h2.25a.75.75 0 1 1 0 1.5h-2.25a.75.75 0 0 1-.75-.75ZM6.748 14.993a.75.75 0 0 1 .75-.75h4.5a.75.75 0 0 1 0 1.5h-4.5a.75.75 0 0 1-.75-.75Z" />
                        <path fill-rule="evenodd"
                            d="M18 2.993a.75.75 0 0 0-1.5 0v1.5h-9V2.994a.75.75 0 1 0-1.5 0v1.497h-.752a3 3 0 0 0-3 3v11.252a3 3 0 0 0 3 3h13.5a3 3 0 0 0 3-3V7.492a3 3 0 0 0-3-3H18V2.993ZM3.748 18.743v-7.5a1.5 1.5 0 0 1 1.5-1.5h13.5a1.5 1.5 0 0 1 1.5 1.5v7.5a1.5 1.5 0 0 1-1.5 1.5h-13.5a1.5 1.5 0 0 1-1.5-1.5Z"
                            clip-rule="evenodd" />
                    </svg>


                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        @lang('visitor-management::visit-appointments.modal.add.heading')
                    </h3>
                </div>
                <button x-on:click="hideModal()" type="button"
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">
                        @lang('globals::global.action.close')
                    </span>
                </button>
            </div>
            <!-- Modal body -->
            <div>
                {{-- STEPPER --}}
                <ol
                    class="flex items-center w-full text-sm font-medium text-center text-gray-500 dark:text-gray-400 sm:text-base">
                    {{-- x-on:click="wizardStep =  @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::General->value)" --}}
                    <li :class="{ 'text-primary-600 dark:text-primary-500': wizardStep >= @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::General->value) }"
                        class="flex md:w-full items-center sm:after:content-[''] after:w-full after:h-1 after:border-b after:border-gray-200 after:border-1 after:hidden sm:after:inline-block after:mx-6 xl:after:mx-10 dark:after:border-gray-700">
                        <span
                            class="flex items-center after:content-['/'] sm:after:hidden after:mx-2 after:text-gray-200 dark:after:text-gray-500">
                            <svg x-show="wizardStep > @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::General->value)"
                                class="w-3.5 h-3.5 sm:w-4 sm:h-4 me-2.5" aria-hidden="true"
                                xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                <path
                                    d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z" />
                            </svg>
                            <span x-show="wizardStep == @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::General->value)"
                                class="relative flex size-5 shrink-0 items-center justify-center me-1"
                                aria-hidden="true">
                                <span class="absolute size-4 rounded-full bg-primary-200"></span>
                                <span class="relative block size-2 rounded-full bg-primary-600"></span>
                            </span>
                            @lang('visitor-management::visit-appointments.wizard.general')
                        </span>
                    </li>
                    {{-- x-on:click="wizardStep =  @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Visitors->value)" --}}
                    <li :class="{ 'text-primary-600 dark:text-primary-500': wizardStep >= @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Visitors->value) }"
                        class="flex md:w-full items-center after:content-[''] after:w-full after:h-1 after:border-b after:border-gray-200 after:border-1 after:hidden sm:after:inline-block after:mx-6 xl:after:mx-10 dark:after:border-gray-700">
                        <span
                            class="flex items-center after:content-['/'] sm:after:hidden after:mx-2 after:text-gray-200 dark:after:text-gray-500">
                            <svg x-show="wizardStep > @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Visitors->value)"
                                class="w-3.5 h-3.5 sm:w-4 sm:h-4 me-2.5" aria-hidden="true"
                                xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                <path
                                    d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z" />
                            </svg>
                            <span x-show="wizardStep == @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Visitors->value)"
                                class="relative flex size-5 shrink-0 items-center justify-center me-1"
                                aria-hidden="true">
                                <span class="absolute size-4 rounded-full bg-primary-200"></span>
                                <span class="relative block size-2 rounded-full bg-primary-600"></span>
                            </span>
                            @lang('visitor-management::visit-appointments.wizard.visitors')
                        </span>
                    </li>
                    <li :class="{ 'text-primary-600 dark:text-primary-500': wizardStep >= @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Overview->value) }"
                        class="flex items-center">
                        <span x-show="wizardStep == @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Overview->value)"
                            class="relative flex size-5 shrink-0 items-center justify-center me-1" aria-hidden="true">
                            <span class="absolute size-4 rounded-full bg-primary-200"></span>
                            <span class="relative block size-2 rounded-full bg-primary-600"></span>
                        </span>
                        @lang('visitor-management::visit-appointments.wizard.summary')
                    </li>
                </ol>
                <div id="tabContainer" class="my-8">
                    {{-- GENERAL --}}
                    <div x-show="wizardStep == @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::General->value)" class="grid gap-4 my-4 sm:grid-cols-2">
                        <div class="flex items-center"
                            x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.spontaneous_visit ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                            <label class="inline-flex items-center cursor-pointer">
                                <input id="isSpontaneousVisit" :disabled="createSucceeded"
                                    wire:model="isSpontaneousVisit" type="checkbox" value="" class="sr-only peer">
                                <div
                                    class="relative w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary-300 dark:peer-focus:ring-primary-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary-600">
                                </div>
                                <span class="ms-3 text-sm font-medium text-gray-900 dark:text-gray-300">
                                    @lang('visitor-management::visit-appointments.label.spontaneous-visit')
                                </span>
                            </label>
                            <x-input-error for="isSpontaneousVisit" />
                        </div>
                        <div class="col-span-2">
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="subject" class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.subject')
                                    <x-global-components::global.input-required-hint
                                        x-show="(visitReasons?.find((element) => element.id == visitReasonId)?.visit_type?.dependencies?.subject ?? {{ \BplanBase\Globals\Enums\RequireStatus::Required }}) >= {{ \BplanBase\Globals\Enums\RequireStatus::Required }}" />
                                </label>
                            </div>
                            <input :disabled="createSucceeded" @keyup.enter="$wire.createAppointment" type="text"
                                wire:model="subject" id="subject"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-appointments.placeholder.subject')">
                            <x-input-error for="subject" />
                        </div>
                        <div x-cloak>
                            <label for="visitReasonId"
                                class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-appointments.label.visit-reason')
                                <x-global-components::global.input-required-hint />
                            </label>
                            <select x-on:change="isBulkVisit = false;" :disabled="createSucceeded"
                                wire:model="visitReasonId" id="visitReasonId"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-appointments.placeholder.visit-reason')">
                                <option>-</option>
                                @foreach ($visitReasonsByVisitType as $visitType => $_visitReasons)
                                    <optgroup label="{{ __('visitor-management::visit-types.identifier.' . $visitType) }}">
                                        @foreach ($_visitReasons as $visitReason)
                                            <option value="{{ $visitReason->id }}">
                                                {{ $visitReason->labels->{app()->getLocale()} ?? 'N/A' }}
                                            </option>
                                        @endforeach
                                    </optgroup>
                                @endforeach
                            </select>

                            <x-input-error for="visitReasonId" />


                            {{-- MASS APPOINTMENT TOGGLE --}}
                            <div class="flex items-center mt-2"
                                x-show="visitReasonId != null && visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.identifier == '{{ \BplanModules\VisitorManagement\Enums\VisitTypeIdentifier::SingleVisit }}'">
                                <label class="inline-flex items-center cursor-pointer">
                                    <input id="isBulkVisit" :disabled="createSucceeded" wire:model="isBulkVisit"
                                        type="checkbox" value="" class="sr-only peer">
                                    <div
                                        class="relative w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary-300 dark:peer-focus:ring-primary-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary-600">
                                    </div>
                                    <span class="ms-3 text-sm font-medium text-gray-900 dark:text-gray-300">
                                        @lang('visitor-management::visit-appointments.label.mass-appointment')
                                    </span>
                                </label>
                                <x-input-error for="isBulkVisit" />
                            </div>
                        </div>
                        <div class="col-start-1"
                            x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.valid_from ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="startDate"
                                    class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.start-date')
                                    <x-global-components::global.input-required-hint />
                                </label>
                            </div>
                            <div wire:ignore>
                                <input :disabled="createSucceeded" @keyup.enter="$wire.createAppointment"
                                    type="text" readonly="readonly" wire:model="startDate" id="startDate"
                                    class="flatpickr-input bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                    placeholder="@lang('visitor-management::visit-appointments.placeholder.start-date')">
                            </div>
                            <x-input-error for="startDate" />
                        </div>
                        <div
                            x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.valid_from ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="startTime"
                                    class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.start-time')
                                    <x-global-components::global.input-required-hint />
                                </label>
                            </div>
                            <div class="relative">
                                <div
                                    class="absolute inset-y-0 end-0 top-0 flex items-center pe-3.5 pointer-events-none">
                                    <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" aria-hidden="true"
                                        xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 24 24">
                                        <path fill-rule="evenodd"
                                            d="M2 12C2 6.477 6.477 2 12 2s10 4.477 10 10-4.477 10-10 10S2 17.523 2 12Zm11-4a1 1 0 1 0-2 0v4a1 1 0 0 0 .293.707l3 3a1 1 0 0 0 1.414-1.414L13 11.586V8Z"
                                            clip-rule="evenodd" />
                                    </svg>
                                </div>
                                <div wire:ignore>
                                    <input :disabled="createSucceeded" @keyup.enter="$wire.createAppointment"
                                        type="time" wire:model="startTime" id="startTime"
                                        class="flatpickr-input bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                        placeholder="@lang('visitor-management::visit-appointments.placeholder.start-time')">
                                </div>
                            </div>
                            <x-input-error for="startTime" />
                        </div>
                        <div class="col-start-1"
                            x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.end ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="endDate" class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.end-date')
                                    <x-global-components::global.input-required-hint />
                                </label>
                            </div>
                            <div wire:ignore>
                                <input :disabled="createSucceeded" @keyup.enter="$wire.createAppointment"
                                    type="text" readonly="readonly" wire:model="endDate" id="endDate"
                                    class="flatpickr-input bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                    placeholder="@lang('visitor-management::visit-appointments.placeholder.end-date')">
                            </div>
                            <x-input-error for="endDate" />
                            <x-input-error for="appointmentEnd" />
                        </div>
                        <div
                            x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.end ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="endTime" class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.end-time')
                                    <x-global-components::global.input-required-hint />
                                </label>
                            </div>
                            <div class="relative">
                                <div
                                    class="absolute inset-y-0 end-0 top-0 flex items-center pe-3.5 pointer-events-none">
                                    <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" aria-hidden="true"
                                        xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 24 24">
                                        <path fill-rule="evenodd"
                                            d="M2 12C2 6.477 6.477 2 12 2s10 4.477 10 10-4.477 10-10 10S2 17.523 2 12Zm11-4a1 1 0 1 0-2 0v4a1 1 0 0 0 .293.707l3 3a1 1 0 0 0 1.414-1.414L13 11.586V8Z"
                                            clip-rule="evenodd" />
                                    </svg>
                                </div>
                                <input :disabled="createSucceeded" @keyup.enter="$wire.createAppointment"
                                    type="time" wire:model="endTime" id="endTime"
                                    class="flatpickr-input bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                    placeholder="@lang('visitor-management::visit-appointments.placeholder.end-time')">
                            </div>
                            <x-input-error for="endTime" />
                        </div>
                    </div>
                    {{-- VISITORS --}}
                    <div x-show="wizardStep == @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Visitors->value)" class="grid gap-4 my-4 sm:grid-cols-2">
                        <div
                            x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.organizer_employee_id ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                            <label for="comboBoxOrganizer"
                                class="flex space-x-1 mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-appointments.label.organizer')
                                <x-global-components::global.input-required-hint
                                    x-show="!isSpontaneousVisit && (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.organizer_employee_id ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) >= {{ \BplanBase\Globals\Enums\RequireStatus::Required }}" />
                                <x-global-components::global.information-icon
                                    data-tippy-content="{{ __('visitor-management::visit-appointments.organizer_information') }}" />
                            </label>
                            <x-global-components::inputs.combo-box itemsKey="organizers" :items="$filteredComboBoxData['organizers']" :placeholder="__('visitor-management::visit-employees.search_for_employees')"
                                :multiple="false" />
                            <div class="mt-2">
                                @foreach ($comboBoxData['organizers'] as $index => $comboBoxMainEmployees)
                                    @if (isset($comboBoxMainEmployees['isSelected']) && $comboBoxMainEmployees['isSelected'])
                                        <x-global-components::inputs.combo-box-badge :label="$comboBoxMainEmployees['label'] ?? ''" itemsKey="organizers"
                                            :index="$index" />
                                    @endif
                                @endforeach
                            </div>
                            <x-input-error for="organizerEmployeeId" />
                        </div>
                        <div
                            x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.main_employee_id ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                            <label for="comboBoxMainEmployee"
                                class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-appointments.label.employee')
                                <x-global-components::global.input-required-hint
                                    x-show="!isSpontaneousVisit && (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.main_employee_id ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) >= {{ \BplanBase\Globals\Enums\RequireStatus::Required }}" />
                            </label>
                            <x-global-components::inputs.combo-box itemsKey="mainEmployees" :items="$filteredComboBoxData['mainEmployees']" :placeholder="__('visitor-management::visit-employees.search_for_employees')"
                                :multiple="false" />
                            <div class="mt-2">
                                @foreach ($comboBoxData['mainEmployees'] as $index => $comboBoxMainEmployees)
                                    @if (isset($comboBoxMainEmployees['isSelected']) && $comboBoxMainEmployees['isSelected'])
                                        <x-global-components::inputs.combo-box-badge :label="$comboBoxMainEmployees['label'] ?? ''" itemsKey="mainEmployees"
                                            :index="$index" />
                                    @endif
                                @endforeach
                            </div>
                            <x-input-error for="mainEmployeeId" />
                        </div>
                        <div
                            x-show="isBulkVisit == false && (visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.main_visitor_id ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }})">
                            <label for="comboBoxMainVisitor"
                                class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-appointments.label.main-visitor')
                                <x-global-components::global.input-required-hint
                                    x-show="!isSpontaneousVisit && (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.main_visitor_id ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) >= {{ \BplanBase\Globals\Enums\RequireStatus::Required }}" />
                            </label>
                            <x-global-components::inputs.combo-box itemsKey="mainVisitors" :items="$filteredComboBoxData['mainVisitors']" :placeholder="__('visitor-management::visit-visitors.search_for_visitors')"
                                :multiple="false" />
                            <div class="mt-2">
                                @foreach ($comboBoxData['mainVisitors'] as $index => $comboBoxMainVisitors)
                                    @if (isset($comboBoxMainVisitors['isSelected']) && $comboBoxMainVisitors['isSelected'])
                                        <x-global-components::inputs.combo-box-badge :label="$comboBoxMainVisitors['label'] ?? ''" itemsKey="mainVisitors"
                                            :index="$index" />
                                    @endif
                                @endforeach
                            </div>
                            <x-input-error for="mainVisitorId" />
                        </div>
                        <div
                            x-show="(visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.identifier) != @js(\BplanModules\VisitorManagement\Enums\VisitTypeIdentifier::GroupVisit) && (isBulkVisit || visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.visitors ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }})">
                            <label for="comboBoxVisitors"
                                class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-appointments.label.visitors')
                                <x-global-components::global.input-required-hint
                                    x-show="isBulkVisit || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.visitors ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) >= {{ \BplanBase\Globals\Enums\RequireStatus::Required }}" />
                            </label>
                            <x-global-components::inputs.combo-box itemsKey="visitors" :items="$filteredComboBoxData['visitors']" :placeholder="__('visitor-management::visit-visitors.search_for_visitors')" />
                            <div class="mt-2">
                                @foreach ($comboBoxData['visitors'] as $index => $comboBoxVisitor)
                                    @if (isset($comboBoxVisitor['isSelected']) && $comboBoxVisitor['isSelected'])
                                        <x-global-components::inputs.combo-box-badge :label="$comboBoxVisitor['label'] ?? ''" itemsKey="visitors"
                                            :index="$index" />
                                    @endif
                                @endforeach
                            </div>
                            <x-input-error for="visitors" />
                        </div>
                        <div
                            x-show="(visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.identifier) == @js(\BplanModules\VisitorManagement\Enums\VisitTypeIdentifier::GroupVisit)">
                            <label for="visitors"
                                class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-appointments.label.visitors')
                            </label>
                            <div class="flex items-center">
                                <p class="text-gray-400 text-sm mt-2">
                                    @lang('visitor-management::visit-appointments.visitors_import_after_created')
                                </p>
                            </div>
                        </div>
                        <div class="col-start-1">
                            <div class="flex items-center col-start-1 mb-2"
                                x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.drive_on_area_permitted ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                                <label class="inline-flex items-center cursor-pointer">
                                    <input id="driveOnAreaPermitted" :disabled="createSucceeded"
                                        wire:model="driveOnAreaPermitted" type="checkbox" value=""
                                        class="sr-only peer">
                                    <div
                                        class="relative w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary-300 dark:peer-focus:ring-primary-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary-600">
                                    </div>
                                    <span class="ms-3 text-sm font-medium text-gray-900 dark:text-gray-300">
                                        @lang('visitor-management::visit-appointments.label.drive-on-area')
                                    </span>
                                </label>
                                <x-input-error for="driveOnAreaPermitted" />
                            </div>
                            <div :class="{ 'cursor-not-allowed opacity-25': !driveOnAreaPermitted }"
                                :style="{ 'pointer-events': driveOnAreaPermitted ? 'all' : 'none' }"
                                x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.license_plate_formatted ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }} || driveOnAreaPermitted == true">
                                <div class="flex items-center mb-2 space-x-1">
                                    <label for="name"
                                        class="inline-flex text-sm font-medium text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.license-plate')
                                        <x-global-components::global.input-required-hint
                                            x-show="!isSpontaneousVisit && (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type?.dependencies?.license_plate_formatted ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) >= {{ \BplanBase\Globals\Enums\RequireStatus::Required }}" />
                                        {{-- <x-global-components::global.information-icon
                                        data-tippy-content="{{ __('global.license_plate_information') }}" /> --}}
                                    </label>
                                </div>
                                {{-- <x-visitor-management::global.input-license-plates :licensePlates="$licensePlates" target="create" /> --}}
                                <input :disabled="createSucceeded" @keyup.enter="$wire.createAppointment"
                                    type="text" x-on:change wire:model="licensePlateFormatted"
                                    id="licensePlateFormatted"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                    placeholder="@lang('visitor-management::visit-appointments.placeholder.license-plate')">
                                <x-input-error for="licensePlateFormatted" />
                            </div>
                            <x-input-error for="licensePlates" />
                        </div>
                        <div
                            x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type?.dependencies?.order_number ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                            <div class="mt-8"
                                x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.drive_on_area_permitted ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                                {{-- Abstand um checkbox (Zufahrt erlaubt) auszugleichen --}}
                            </div>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="name" class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.order-number')
                                    <x-global-components::global.input-required-hint
                                        x-show="(visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.order_number ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) >= {{ \BplanBase\Globals\Enums\RequireStatus::Required }}" />
                                </label>
                            </div>
                            <input :disabled="createSucceeded" @keyup.enter="$wire.createAppointment" type="text"
                                x-on:change wire:model="orderNumber" id="orderNumber"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-appointments.placeholder.order-number')">
                            <x-input-error for="orderNumber" />
                        </div>
                        <div class="flex items-center col-start-1"
                            :class="{ 'cursor-not-allowed opacity-25': requireEscort }"
                            x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.internal_visit ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                            <label class="inline-flex items-center cursor-pointer">
                                <input id="internalVisit" :disabled="requireEscort || createSucceeded"
                                    wire:model="internalVisit" type="checkbox" value=""
                                    class="sr-only peer">
                                <div
                                    class="relative w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary-300 dark:peer-focus:ring-primary-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary-600">
                                </div>
                                <span class="ms-3 text-sm font-medium text-gray-900 dark:text-gray-300">
                                    @lang('visitor-management::visit-appointments.label.internal-visit')
                                </span>
                            </label>
                            <x-input-error for="internalVisit" />
                        </div>
                        <div class="flex items-center"
                            x-show="visitReasonId == null || visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.with_minors != '{{ \BplanModules\VisitorManagement\Enums\VisitTypeIdentifier::AccessAuthorization->value }}'">
                            <label class="inline-flex items-center cursor-pointer">
                                <input id="withMinors" :disabled="createSucceeded" wire:model.live="withMinors"
                                    type="checkbox" value="" class="sr-only peer">
                                <div
                                    class="relative w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary-300 dark:peer-focus:ring-primary-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary-600">
                                </div>
                                <span class="ms-3 text-sm font-medium text-gray-900 dark:text-gray-300">
                                    @lang('visitor-management::visit-appointments.label.with-minors')
                                </span>
                            </label>
                            <x-input-error for="withMinors" />
                        </div>
                        <div class="flex items-center" :class="{ 'cursor-not-allowed opacity-25': internalVisit }"
                            x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.require_escort ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                            <label class="inline-flex items-center cursor-pointer">
                                <input id="requireEscort" :disabled="internalVisit || createSucceeded"
                                    wire:model.live="requireEscort" type="checkbox" value=""
                                    class="sr-only peer">
                                <div
                                    class="relative w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary-300 dark:peer-focus:ring-primary-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary-600">
                                </div>
                                <span class="ms-3 text-sm font-medium text-gray-900 dark:text-gray-300">
                                    @lang('visitor-management::visit-appointments.label.require-escort')
                                </span>
                            </label>
                            <x-input-error for="requireEscort" />
                        </div>
                    </div>
                    {{-- OVERVIEW --}}
                    <div x-show="wizardStep == @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Overview->value)"
                        class="grid gap-4 my-4 sm:grid-cols-2 md:grid-cols-3">
                        <dl class="grid grid-cols-2 md:col-span-2">
                            <div>
                                <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.organizer')
                                </dt>
                                <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                    @forelse ($comboBoxData['organizers'] ?? [] as $index => $comboBoxMainEmployees)
                                        @if (isset($comboBoxMainEmployees['isSelected']) && $comboBoxMainEmployees['isSelected'])
                                            <span
                                                class="bg-gray-100 text-gray-800 text-xs font-medium inline-flex items-center px-2.5 py-0.5 rounded me-2 dark:bg-gray-700 dark:text-gray-400 border border-gray-500 ">
                                                {{-- USER ICON --}}
                                                <svg class="w-2.5 h-2.5 me-1.5" xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 24 24" fill="currentColor">
                                                    <path fill-rule="evenodd"
                                                        d="M7.5 6a4.5 4.5 0 1 1 9 0 4.5 4.5 0 0 1-9 0ZM3.751 20.105a8.25 8.25 0 0 1 16.498 0 .75.75 0 0 1-.437.695A18.683 18.683 0 0 1 12 22.5c-2.786 0-5.433-.608-7.812-1.7a.75.75 0 0 1-.437-.695Z"
                                                        clip-rule="evenodd" />
                                                </svg>
                                                {{ $comboBoxMainEmployees['label'] ?? '-' }}
                                            </span>
                                        @endif
                                    @empty
                                        -
                                    @endforelse

                                    @if (
                                        (count(array_filter($comboBoxData['organizers'], function (array $visitor) {
                                                return isset($visitor['isSelected']) && $visitor['isSelected'] == true;
                                            })) ??
                                            0) ==
                                            0)
                                        -
                                    @endif
                                </dd>
                            </div>
                            <div>
                                <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.employee')
                                </dt>
                                <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                    @forelse ($comboBoxData['mainEmployees'] ?? [] as $index => $comboBoxMainEmployees)
                                        @if (isset($comboBoxMainEmployees['isSelected']) && $comboBoxMainEmployees['isSelected'])
                                            <span
                                                class="bg-gray-100 text-gray-800 text-xs font-medium inline-flex items-center px-2.5 py-0.5 rounded me-2 dark:bg-gray-700 dark:text-gray-400 border border-gray-500 ">
                                                {{-- USER ICON --}}
                                                <svg class="w-2.5 h-2.5 me-1.5" xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 24 24" fill="currentColor">
                                                    <path fill-rule="evenodd"
                                                        d="M7.5 6a4.5 4.5 0 1 1 9 0 4.5 4.5 0 0 1-9 0ZM3.751 20.105a8.25 8.25 0 0 1 16.498 0 .75.75 0 0 1-.437.695A18.683 18.683 0 0 1 12 22.5c-2.786 0-5.433-.608-7.812-1.7a.75.75 0 0 1-.437-.695Z"
                                                        clip-rule="evenodd" />
                                                </svg>
                                                {{ $comboBoxMainEmployees['label'] ?? '-' }}
                                            </span>
                                        @endif
                                    @empty
                                        -
                                    @endforelse

                                    @if (
                                        (count(array_filter($comboBoxData['mainEmployees'], function (array $visitor) {
                                                return isset($visitor['isSelected']) && $visitor['isSelected'] == true;
                                            })) ??
                                            0) ==
                                            0)
                                        -
                                    @endif
                                </dd>
                            </div>
                            <div x-show="isBulkVisit == false">
                                <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.main-visitor')
                                </dt>
                                <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                    @forelse ($comboBoxData['mainVisitors'] ?? [] as $index => $comboBoxMainEmployees)
                                        @if (isset($comboBoxMainEmployees['isSelected']) && $comboBoxMainEmployees['isSelected'])
                                            <span
                                                class="bg-gray-100 text-gray-800 text-xs font-medium inline-flex items-center px-2.5 py-0.5 rounded me-2 dark:bg-gray-700 dark:text-gray-400 border border-gray-500 ">
                                                {{-- USER ICON --}}
                                                <svg class="w-2.5 h-2.5 me-1.5" xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 24 24" fill="currentColor">
                                                    <path fill-rule="evenodd"
                                                        d="M7.5 6a4.5 4.5 0 1 1 9 0 4.5 4.5 0 0 1-9 0ZM3.751 20.105a8.25 8.25 0 0 1 16.498 0 .75.75 0 0 1-.437.695A18.683 18.683 0 0 1 12 22.5c-2.786 0-5.433-.608-7.812-1.7a.75.75 0 0 1-.437-.695Z"
                                                        clip-rule="evenodd" />
                                                </svg>
                                                {{ $comboBoxMainEmployees['label'] ?? '-' }}
                                            </span>
                                        @endif
                                    @empty
                                        -
                                    @endforelse

                                    @if (
                                        (count(array_filter($comboBoxData['mainVisitors'], function (array $visitor) {
                                                return isset($visitor['isSelected']) && $visitor['isSelected'] == true;
                                            })) ??
                                            0) ==
                                            0)
                                        -
                                    @endif
                                </dd>
                            </div>
                            <div>
                                <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.visitors')
                                </dt>
                                <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                    @foreach ($comboBoxData['visitors'] ?? [] as $index => $comboBoxVisitor)
                                        @if (isset($comboBoxVisitor['isSelected']) && $comboBoxVisitor['isSelected'])
                                            <span
                                                class="bg-gray-100 text-gray-800 text-xs font-medium inline-flex items-center px-2.5 py-0.5 rounded me-2 dark:bg-gray-700 dark:text-gray-400 border border-gray-500 ">
                                                {{-- USER ICON --}}
                                                <svg class="w-2.5 h-2.5 me-1.5" xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 24 24" fill="currentColor">
                                                    <path fill-rule="evenodd"
                                                        d="M7.5 6a4.5 4.5 0 1 1 9 0 4.5 4.5 0 0 1-9 0ZM3.751 20.105a8.25 8.25 0 0 1 16.498 0 .75.75 0 0 1-.437.695A18.683 18.683 0 0 1 12 22.5c-2.786 0-5.433-.608-7.812-1.7a.75.75 0 0 1-.437-.695Z"
                                                        clip-rule="evenodd" />
                                                </svg>
                                                {{ $comboBoxVisitor['label'] ?? '-' }}
                                            </span>
                                        @endif
                                    @endforeach

                                    @if (
                                        (count(array_filter($comboBoxData['visitors'], function (array $visitor) {
                                                return isset($visitor['isSelected']) && $visitor['isSelected'] == true;
                                            })) ??
                                            0) ==
                                            0)
                                        -
                                    @endif
                                </dd>
                            </div>
                            <div>
                                <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.drive-on-area')
                                </dt>
                                <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                    @if ($driveOnAreaPermitted)
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                            fill="currentColor" class="size-6 text-green-500">
                                            <path fill-rule="evenodd"
                                                d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12Zm13.36-1.814a.75.75 0 1 0-1.22-.872l-3.236 4.53L9.53 12.22a.75.75 0 0 0-1.06 1.06l2.25 2.25a.75.75 0 0 0 1.14-.094l3.75-5.25Z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    @else
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                            fill="currentColor" class="size-6 text-red-500">
                                            <path fill-rule="evenodd"
                                                d="M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25Zm-1.72 6.97a.75.75 0 1 0-1.06 1.06L10.94 12l-1.72 1.72a.75.75 0 1 0 1.06 1.06L12 13.06l1.72 1.72a.75.75 0 1 0 1.06-1.06L13.06 12l1.72-1.72a.75.75 0 1 0-1.06-1.06L12 10.94l-1.72-1.72Z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    @endif
                                </dd>
                            </div>
                            <div
                                x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.license_plate_formatted ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }} || driveOnAreaPermitted == true">
                                <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.license-plate')
                                </dt>
                                <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                    {{ $licensePlateFormatted ?? '-' }}
                                </dd>
                            </div>
                            <div>
                                <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.internal-visit')
                                </dt>
                                <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                    @if ($internalVisit)
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                            fill="currentColor" class="size-6 text-green-500">
                                            <path fill-rule="evenodd"
                                                d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12Zm13.36-1.814a.75.75 0 1 0-1.22-.872l-3.236 4.53L9.53 12.22a.75.75 0 0 0-1.06 1.06l2.25 2.25a.75.75 0 0 0 1.14-.094l3.75-5.25Z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    @else
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                            fill="currentColor" class="size-6 text-red-500">
                                            <path fill-rule="evenodd"
                                                d="M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25Zm-1.72 6.97a.75.75 0 1 0-1.06 1.06L10.94 12l-1.72 1.72a.75.75 0 1 0 1.06 1.06L12 13.06l1.72 1.72a.75.75 0 1 0 1.06-1.06L13.06 12l1.72-1.72a.75.75 0 1 0-1.06-1.06L12 10.94l-1.72-1.72Z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    @endif
                                </dd>
                            </div>
                            <div>
                                <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.require-escort')
                                </dt>
                                <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                    @if ($requireEscort)
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                            fill="currentColor" class="size-6 text-green-500">
                                            <path fill-rule="evenodd"
                                                d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12Zm13.36-1.814a.75.75 0 1 0-1.22-.872l-3.236 4.53L9.53 12.22a.75.75 0 0 0-1.06 1.06l2.25 2.25a.75.75 0 0 0 1.14-.094l3.75-5.25Z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    @else
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                            fill="currentColor" class="size-6 text-red-500">
                                            <path fill-rule="evenodd"
                                                d="M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25Zm-1.72 6.97a.75.75 0 1 0-1.06 1.06L10.94 12l-1.72 1.72a.75.75 0 1 0 1.06 1.06L12 13.06l1.72 1.72a.75.75 0 1 0 1.06-1.06L13.06 12l1.72-1.72a.75.75 0 1 0-1.06-1.06L12 10.94l-1.72-1.72Z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    @endif
                                </dd>
                            </div>
                            <div>
                                <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.with-minors')
                                </dt>
                                <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                    @if ($withMinors)
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                            fill="currentColor" class="size-6 text-green-500">
                                            <path fill-rule="evenodd"
                                                d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12Zm13.36-1.814a.75.75 0 1 0-1.22-.872l-3.236 4.53L9.53 12.22a.75.75 0 0 0-1.06 1.06l2.25 2.25a.75.75 0 0 0 1.14-.094l3.75-5.25Z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    @else
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                            fill="currentColor" class="size-6 text-red-500">
                                            <path fill-rule="evenodd"
                                                d="M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25Zm-1.72 6.97a.75.75 0 1 0-1.06 1.06L10.94 12l-1.72 1.72a.75.75 0 1 0 1.06 1.06L12 13.06l1.72 1.72a.75.75 0 1 0 1.06-1.06L13.06 12l1.72-1.72a.75.75 0 1 0-1.06-1.06L12 10.94l-1.72-1.72Z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    @endif
                                </dd>
                            </div>
                        </dl>
                        <dl class="flex flex-col space-y-2 bg-gray-50 dark:bg-gray-500 rounded p-4">
                            <div>
                                <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.subject')
                                </dt>
                                <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                    {{ $subject ?? '-' }}
                                </dd>
                            </div>
                            <div>
                                <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.start-date')
                                </dt>
                                <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                    {{ \Carbon\Carbon::parse($appointmentBegin)->format(__('globals::global.datetime.format')) }}
                                </dd>
                            </div>
                            <div>
                                <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.end-date')
                                </dt>
                                <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                    {{ \Carbon\Carbon::parse($appointmentEnd)->format(__('globals::global.datetime.format')) }}
                                </dd>
                            </div>
                            <div>
                                <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.visit-reason')
                                </dt>
                                <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                    {{ $visitReasonLabels->{app()->getLocale()} ?? 'N/A' }}
                                </dd>
                            </div>
                        </dl>
                    </div>
                </div>

                <div class="flex justify-between">
                    <div>
                        <button x-show="currentStep > @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::General->value)" wire:click="previousStep"
                            type="button"
                            class="py-2.5 px-5 me-2 mb-2 text-sm font-medium text-gray-900 focus:outline-none bg-white rounded-lg border border-gray-200 hover:bg-gray-100 hover:text-primary-700 focus:z-10 focus:ring-4 focus:ring-gray-100 dark:focus:ring-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700">
                            @lang('globals::global.pagination.previous')
                        </button>
                    </div>
                    <div>
                        <div x-show="currentStep < @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Overview->value)">
                            <button wire:click="nextStep" type="button"
                                class="py-2.5 px-5 me-2 mb-2 text-sm font-medium text-gray-900 focus:outline-none bg-white rounded-lg border border-gray-200 hover:bg-gray-100 hover:text-primary-700 focus:z-10 focus:ring-4 focus:ring-gray-100 dark:focus:ring-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700">
                                @lang('globals::global.pagination.next')
                            </button>
                        </div>
                        <div x-show="currentStep == @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Overview->value)">
                            <button wire:loading.remove wire:target="createAppointment" wire:click="createAppointment"
                                type="button"
                                class="text-white inline-flex items-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                                <svg class="w-6 h-6 mr-1 -ml-1" fill="currentColor" viewBox="0 0 20 20"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd"
                                        d="M10 5a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3H6a1 1 0 110-2h3V6a1 1 0 011-1z"
                                        clip-rule="evenodd"></path>
                                </svg>
                                @lang('visitor-management::visit-appointments.action.create')
                            </button>
                            <x-global-components::global.loading-spinner wire:loading wire:target="createAppointment" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('createAppointment', () => ({
                show: false,
                createSucceeded: false,
                wizardStep: @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::General->value),
                currentStep: @entangle('appointmentStep'),
                visitReasons: @js($visitReasons),
                visitReasonId: @entangle('visitReasonId'),
                driveOnAreaPermitted: @entangle('driveOnAreaPermitted'),
                isSpontaneousVisit: @entangle('isSpontaneousVisit'),
                internalVisit: @entangle('internalVisit'),
                requireEscort: @entangle('requireEscort'),
                isBulkVisit: @entangle('isBulkVisit'),
                init() {
                    flatpickr("#startDate", {
                        locale: @js(app()->getLocale()),
                        dateFormat: "Y-m-d",
                        altInput: true,
                        altFormat: @js(__('globals::global.date.format')),
                    });
                    flatpickr("#endDate", {
                        locale: @js(app()->getLocale()),
                        dateFormat: "Y-m-d",
                        altInput: true,
                        altFormat: @js(__('globals::global.date.format')),
                    });
                    flatpickr("#startTime", {
                        locale: @js(app()->getLocale()),
                        altInput: true,
                        altFormat: "H:i",
                        enableTime: true,
                        noCalendar: true,
                        dateFormat: "H:i",
                        time_24hr: true
                    });
                    flatpickr("#endTime", {
                        locale: @js(app()->getLocale()),
                        altInput: true,
                        altFormat: "H:i",
                        enableTime: true,
                        noCalendar: true,
                        dateFormat: "H:i",
                        time_24hr: true
                    });
                },
                // CREATE
                created(event) {
                    this.createSucceeded = true;
                    this.hideModal();
                },
                resetModal() {
                    this.createSucceeded = false;
                    this.currentStep = @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::General->value);
                    this.wizardStep = @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::General->value);

                    @this.resetModal()
                },
                hideModal() {
                    this.show = false;
                    this.resetModal();
                },
                showModal(event) {
                    this.show = true;

                    setTimeout(() => {
                        document.getElementById('subject').focus();
                    }, 100);
                },
                paginationUpdated(event) {
                    this.wizardStep = event.detail.step;
                }
            }));
        });
    </script>
</div>
