<div>
    <div class="flex space-y-2 mt-8">
        @foreach (\BplanModules\VisitorManagement\Enums\ContactOptionContext::cases() as $context)
            <div wire:key="group-{{ $context }}">
                <h5 wire:sortable.handle
                    class="mb-2 text-4xl font-bold tracking-tight text-gray-900 dark:text-white select-none">
                    @lang('visitor-management::visit-contact-options.context.'.$context->value)
                </h5>
                <div class="mt-6">
                    <ul wire:sortable="updateContactOptionsSequence" class="flex flex-wrap gap-4">
                        @foreach ($sortedContactOptions[$context->value] ?? [] as $key => $contactOption)
                            <li wire:sortable.item="{{ $contactOption->id }}"
                                wire:key="contactOption-{{ $contactOption->id }}"
                                class="relative w-64 p-6 bg-white border border-gray-200 rounded-lg shadow dark:bg-gray-800 dark:border-gray-700">
                                <div
                                    class="absolute inline-flex items-center justify-center w-6 h-6 text-xs font-bold text-white bg-primary-500 border-2 border-white rounded-full -top-2 -start-2 dark:border-gray-900">
                                    {{ $key + 1 }}
                                </div>
                                <div class="flex justify-between">
                                    <h5
                                        class="truncate mb-2 text-xl font-bold tracking-tight text-gray-900 dark:text-white select-none me-3">
                                        {{ $contactOption->labels->{app()->getLocale()} }}
                                    </h5>
                                    {{-- SORT ICON --}}
                                    <svg wire:sortable.handle xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                        fill="currentColor" class="size-6 cursor-move">
                                        <path fill-rule="evenodd"
                                            d="M15.97 2.47a.75.75 0 0 1 1.06 0l4.5 4.5a.75.75 0 0 1 0 1.06l-4.5 4.5a.75.75 0 1 1-1.06-1.06l3.22-3.22H7.5a.75.75 0 0 1 0-1.5h11.69l-3.22-3.22a.75.75 0 0 1 0-1.06Zm-7.94 9a.75.75 0 0 1 0 1.06l-3.22 3.22H16.5a.75.75 0 0 1 0 1.5H4.81l3.22 3.22a.75.75 0 1 1-1.06 1.06l-4.5-4.5a.75.75 0 0 1 0-1.06l4.5-4.5a.75.75 0 0 1 1.06 0Z"
                                            clip-rule="evenodd" />
                                    </svg>
                                </div>
                                <div class="flex justify-between">
                                    <div class="flex items-center">
                                        <p class="font-normal text-gray-700 dark:text-gray-400">
                                            {{ $contactOption->value }}
                                        </p>
                                        <button x-on:click="$dispatch('show-edit-contact-option-modal', { contactOption: @js($contactOption) })" class="ml-2">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                fill="currentColor" class="size-4">
                                                <path
                                                    d="M21.731 2.269a2.625 2.625 0 0 0-3.712 0l-1.157 1.157 3.712 3.712 1.157-1.157a2.625 2.625 0 0 0 0-3.712ZM19.513 8.199l-3.712-3.712-12.15 12.15a5.25 5.25 0 0 0-1.32 2.214l-.8 2.685a.75.75 0 0 0 .933.933l2.685-.8a5.25 5.25 0 0 0 2.214-1.32L19.513 8.2Z" />
                                            </svg>
                                        </button>
                                    </div>

                                </div>
                            </li>
                        @endforeach
                        <div class="flex items-center">
                            <button
                                x-on:click="$dispatch('show-add-contact-option-modal', {context: @js($context) })"
                                type="button"
                                class="text-primary-700 border border-primary-700 hover:bg-primary-700 hover:text-white focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-full text-sm p-2.5 text-center inline-flex items-center dark:border-primary-500 dark:text-primary-500 dark:hover:text-white dark:focus:ring-primary-800 dark:hover:bg-primary-500">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                    class="size-4">
                                    <path fill-rule="evenodd"
                                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                        clip-rule="evenodd" />
                                </svg>

                                <span class="sr-only">
                                    Add Contact number
                                </span>
                            </button>
                        </div>
                    </ul>
                </div>
            </div>
        @endforeach
    </div>

    <livewire:visitor-management::visit-contact-options.modals.add />
    <livewire:visitor-management::visit-contact-options.modals.edit />
    <livewire:visitor-management::global.modals.multi-language-json languageContext="{{ \BplanModules\VisitorManagement\Enums\LanguageContext::Both->value }}" />
</div>
