<div x-data="uploadDocument" x-cloak x-show="show" id="uploadDocumentModal" tabindex="-1"
    x-on:show-upload-document-modal.window="showModal()" x-on:document-uploaded.window="uploaded($event)"
    class="fixed top-0 left-0 right-0 z-50 flex items-center justify-center w-full h-screen overflow-x-hidden overflow-y-auto md:inset-0 md:h-full">
    <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75"></div>
    <div class="relative w-full h-full max-w-2xl p-4 md:h-auto">
        <!-- Modal content -->
        <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
            <!-- Modal header -->
            <div class="flex items-center justify-between pb-4 mb-4 border-b rounded-t sm:mb-5 dark:border-gray-600">

                <div class="flex items-center space-x-2 text-gray-900 dark:text-white">
                    <svg class="size-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke-width="1.5" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5m-13.5-9L12 3m0 0 4.5 4.5M12 3v13.5" />
                    </svg>

                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        @lang('visitor-management::visit-documents.modal.upload.heading')
                    </h3>
                </div>
                <button x-on:click="hideModal()" type="button"
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">
                        @lang('globals::global.action.close')
                    </span>
                </button>
            </div>
            <!-- Modal body -->
            <div>
                <div class="grid gap-4 mb-4 sm:grid-cols-2">
                    <div class="col-span-2 p-4 mt-2 text-sm text-yellow-800 rounded-lg bg-yellow-50 dark:bg-gray-800 dark:text-yellow-300"
                        role="alert">
                        <div class="flex items-center space-x-1">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                class="text-yellow-300 size-6">
                                <path fill-rule="evenodd"
                                    d="M9.401 3.003c1.155-2 4.043-2 5.197 0l7.355 12.748c1.154 2-.29 4.5-2.599 4.5H4.645c-2.309 0-3.752-2.5-2.598-4.5L9.4 3.003ZM12 8.25a.75.75 0 0 1 .75.75v3.75a.75.75 0 0 1-1.5 0V9a.75.75 0 0 1 .75-.75Zm0 8.25a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z"
                                    clip-rule="evenodd" />
                            </svg>
                            <p class="text-lg font-bold">
                                @lang('globals::global.heading.notice')
                            </p>
                        </div>
                        <span class="font-medium">
                            @lang('visitor-management::visit-documents.info.upload-notice')
                        </span>
                    </div>

                    <div x-cloak>
                        <label for="fileType" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                            @lang('visitor-management::visit-documents.label.file-type')
                            <x-global-components::global.input-required-hint />
                        </label>
                        <select :disabled="uploadSucceeded" wire:model.live="fileType" id="visitReasonId"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-documents.label.visit-reason')" required="">
                            <option>-</option>
                            @foreach ($fileTypes as $fileType)
                                <option value="{{ $fileType }}">
                                    @lang("visitor-management::visit-documents.attachment-types.{$fileType}")
                                </option>
                            @endforeach
                        </select>
                        <x-input-error for="fileType" />
                    </div>

                    <div x-cloak>
                        <label for="fileLanguage" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                            @lang('visitor-management::visit-documents.label.file-language')
                            <x-global-components::global.input-required-hint />
                        </label>
                        <select :disabled="uploadSucceeded" wire:model.live="fileLanguage" id="visitReasonId"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-documents.label.visit-reason')" required="">
                            <option>-</option>
                            @foreach ($languages as $language)
                                <option value="{{ $language }}">
                                    @lang("globals::global.languages.$language")
                                </option>
                            @endforeach
                        </select>
                        <x-input-error for="fileLanguage" />
                    </div>

                    <div x-cloak>
                        <label for="visitTypesGroup" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                            @lang('visitor-management::visit-documents.label.visit-group')
                        </label>
                        <select :disabled="uploadSucceeded" wire:model.live="visitTypesGroup" id="visitTypesGroup"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-documents.placeholder.visit-group')" required="">
                            <option>
                                @lang('globals::global.select-option.all')
                            </option>
                            @foreach (\BplanModules\VisitorManagement\Enums\VisitTypeGroupIdentifier::cases() as $visitTypesGroup)
                                @if($visitTypesGroup ==  \BplanModules\VisitorManagement\Enums\VisitTypeGroupIdentifier::Internals)
                                    @continue
                                @endif
                                <option value="{{ $visitTypesGroup }}">
                                    @lang("visitor-management::visit-appointments.visit-group.$visitTypesGroup->value")
                                </option>
                            @endforeach
                        </select>
                        <x-input-error for="visitTypesGroup" />
                    </div>

                    <div x-cloak>
                        <label for="visitTypes" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                            @lang('visitor-management::visit-documents.label.visit-type')
                        </label>
                        <select :disabled="uploadSucceeded" wire:model.live="visitType" id="visitType"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-documents.placeholder.visit-type')" required="">
                            <option>
                                @lang('globals::global.select-option.all')
                            </option>
                            @foreach ($visitTypes ?? [] as $visitType)
                                <option value="{{ $visitType }}">
                                    @lang("visitor-management::visit-types.identifier.{$visitType->identifier}")
                                </option>
                            @endforeach
                        </select>
                        <x-input-error for="visitTypes" />
                    </div>


                    <div class="py-2 sm:py-3 col-span-2" x-data="{ uploading: false, progress: 0 }"
                        x-on:livewire-upload-start="uploading = true" x-on:livewire-upload-finish="uploading = false"
                        x-on:livewire-upload-cancel="uploading = false" x-on:livewire-upload-error="uploading = false"
                        x-on:livewire-upload-progress="progress = $event.detail.progress">
                        <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white" for="file_input">
                            @lang('globals::global.action.upload')
                        </label>
                        <!-- Progress Bar -->
                        <div x-show="uploading" class="flex items-center space-x-2">
                            <div class="w-full bg-gray-200 rounded-full h-2.5 dark:bg-gray-700">
                                <div class="bg-primary-600 h-2.5 rounded-full" :style="'width: ' + progress + '%'">
                                </div>
                            </div>
                            <!-- Cancel upload button -->
                            <button type="button" wire:click="$cancelUpload('documentFile')"
                                class="inline-flex items-center px-3 py-2 text-xs font-medium text-center text-white rounded-lg bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                    class="size-4">
                                    <path fill-rule="evenodd"
                                        d="M5.47 5.47a.75.75 0 0 1 1.06 0L12 10.94l5.47-5.47a.75.75 0 1 1 1.06 1.06L13.06 12l5.47 5.47a.75.75 0 1 1-1.06 1.06L12 13.06l-5.47 5.47a.75.75 0 0 1-1.06-1.06L10.94 12 5.47 6.53a.75.75 0 0 1 0-1.06Z"
                                        clip-rule="evenodd" />
                                </svg>
                                @lang('globals::global.action.cancel-upload')
                            </button>
                        </div>

                        <input x-show="!uploading" wire:model="documentFile"
                            class="block w-full text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 dark:text-gray-400 focus:outline-none dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400"
                            type="file" accept="application/pdf">
                        <div x-data="{ uploadSuccessMessage: @entangle('uploadSuccessMessage') }">
                            <p x-show="uploadSuccessMessage != ''" x-text="uploadSuccessMessage"
                                class="text-green-500 text-center mt-2">
                            </p>
                        </div>
                        <x-input-error for="documentFile" />
                    </div>
                    @if (!empty($documentName))
                        <div class="col-span-2">
                        <div class="flex items-center p-4 mb-4 text-sm text-primary-800 rounded-lg bg-primary-50 dark:bg-gray-800 dark:text-primary-400"
                            role="alert">
                            <svg class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true"
                                xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                <path
                                    d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z" />
                            </svg>
                            <span class="sr-only">Info</span>
                            <div>
                                @lang('visitor-management::visit-documents.info.renaming-file', [
                                    'filename' => $documentName,
                                ])
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
                <div x-show="!uploadSucceeded" class="flex justify-end">
                    <button wire:loading.remove wire:target="uploadDocument" wire:click="uploadDocument"
                        type="button"
                        class="text-white inline-flex items-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                        <svg class="w-5 h-5 mr-1 -ml-1"xmlns="http://www.w3.org/2000/svg" fill="none"
                            viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5m-13.5-9L12 3m0 0 4.5 4.5M12 3v13.5" />
                        </svg>

                        @lang('visitor-management::visit-documents.action.upload')
                    </button>
                    <x-global-components::global.loading-spinner wire:loading wire:target="uploadDocument" />
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('uploadDocument', () => ({
                show: false,
                uploadSucceeded: false,

                uploaded(event) {
                    this.uploadSucceeded = true;

                    setTimeout(() => {
                        this.hideModal();
                    }, 3000);
                },
                resetModal() {
                    this.uploadSucceeded = false;

                    @this.resetModal()
                },
                hideModal() {
                    this.show = false;
                    this.resetModal();
                },
                showModal(id) {
                    this.show = true;
                    setTimeout(() => {
                        // document.getElementById('firstname').focus();
                    }, 100);
                }
            }));
        });
    </script>
</div>
