<div>
    <div class="my-4">
        <h2 class="text-4xl font-extrabold dark:text-white">
            @lang('visitor-management::visit-locations.page.heading')
        </h2>
        <p class="my-4 text-lg text-gray-500">
            @lang('visitor-management::visit-locations.page.description')
        </p>
    </div>
    <div class="relative bg-white shadow-md dark:bg-gray-800 sm:rounded-lg">
        <div class="p-4">
            <div class="flex flex-col items-center justify-between space-y-3 md:flex-row md:space-y-0 md:space-x-4">
                {{-- SEARCH --}}
                <div class="w-full md:w-1/2">
                    {{-- <label for="search" class="invisible">
                        @lang('visitor-management::visit-locations.search.locations')
                    </label> --}}
                    <div class="flex items-center">
                        <div class="relative w-full">
                            <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                <svg aria-hidden="true" class="w-5 h-5 text-gray-500 dark:text-gray-400"
                                    fill="currentColor" viewbox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd"
                                        d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z"
                                        clip-rule="evenodd" />
                                </svg>
                            </div>
                            <input wire:model.live.debounce.500ms="search" type="text" id="search"
                                class="block w-full p-2 pl-10 text-sm text-gray-900 border border-gray-300 rounded-lg bg-gray-50 focus:ring-primary-500 focus:border-primary-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-locations.search.locations')" required="">
                        </div>
                    </div>
                </div>
                <div
                    class="flex flex-col items-stretch justify-end flex-shrink-0 w-full space-y-2 md:w-auto md:flex-row md:space-y-0 md:items-center md:space-x-3">
                    {{--  --}}
                </div>
                <div
                    class="flex flex-col items-stretch justify-end flex-shrink-0 w-full space-y-2 md:w-auto md:flex-row md:space-y-0 md:items-center md:space-x-3">
                    <button x-on:click="$dispatch('show-create-location-modal')" type="button"
                        class="flex items-center justify-center px-4 py-2 text-sm font-medium text-white rounded-lg bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 focus:outline-none dark:focus:ring-primary-800">
                        <svg class="h-3.5 w-3.5 mr-2" fill="currentColor" viewbox="0 0 20 20"
                            xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                            <path clip-rule="evenodd" fill-rule="evenodd"
                                d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z" />
                        </svg>
                        @lang('visitor-management::visit-locations.action.add')
                    </button>
                </div>
            </div>
            {{-- LOCATION FILTER --}}
            <div
                class="flex flex-col items-stretch justify-end flex-shrink-0 w-full md:w-auto md:flex-row md:space-y-0 md:items-center md:space-x-3">

            </div>
        </div>
        @if (count($locations) > 0)
            <div class="overflow-x-auto">
                <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
                    <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                        <tr>
                            <th scope="col" class="px-4 py-3">
                                @lang('globals::global.caption.id')
                            </th>
                            <th scope="col" class="px-4 py-3">
                                @lang('globals::global.caption.label')
                            </th>
                            <th scope="col" class="px-4 py-3">
                                @lang('visitor-management::visit-locations.caption.city')
                            </th>
                            <th scope="col" class="px-4 py-3">
                                @lang('visitor-management::visit-locations.caption.zip-code')
                            </th>
                            <th scope="col" class="px-4 py-3">
                                @lang('visitor-management::visit-locations.caption.street')
                            </th>
                            <th scope="col" class="px-4 py-3">
                                @lang('visitor-management::visit-locations.caption.house-number')
                            </th>
                            <th scope="col" class="px-4 py-3">
                                @lang('visitor-management::visit-locations.caption.sub-locations')
                            </th>
                            <th scope="col" class="px-4 py-3">
                                @lang('globals::global.caption.action')
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($locations as $location)
                            <tr id="location-{{ $location->id }}" class="border-b dark:border-gray-700">
                                <th scope="row"
                                    class="px-4 py-3 font-medium text-gray-900 whitespace-nowrap dark:text-white">
                                    {{ $location->id }}
                                </th>
                                <td class="px-4 py-3">
                                    {{ $location->labels->{app()->getLocale()} }}
                                </td>
                                <td class="px-4 py-3">
                                    {{ $location->city }}
                                </td>
                                <td class="px-4 py-3">
                                    {{ $location->postcode }}
                                </td>
                                <td class="px-4 py-3">
                                    {{ $location->street }}
                                </td>
                                <td class="px-4 py-3">
                                    {{ $location->house_number }}
                                </td>
                                <td class="px-4 py-3">
                                    {{ $location->subLocations()->count() }}
                                </td>
                                <td class="flex py-3">
                                    <button data-tippy-content="{{__('globals::global.action.edit')}}" type="button"
                                        x-on:click="$dispatch('show-edit-location-modal', { location: @js($location) })"
                                        class="inline-flex items-center p-0.5 text-sm font-medium text-center text-gray-500 hover:text-gray-800 rounded-lg focus:outline-none dark:text-gray-400 dark:hover:text-gray-100">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                            stroke-width="1.5" stroke="currentColor" class="w-5 h-5">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                                        </svg>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            @if ($locations->lastPage() > 1)
                <div class="p-4">
                    {{ $locations->links() }}
                </div>
            @endif
        @else
            <div class="max-w-screen-xl px-4 py-8 mx-auto lg:py-16 lg:px-6">
                <div class="max-w-screen-sm mx-auto text-center">
                    <div class="flex justify-center">
                        <svg aria-hidden="true"
                            class="w-24 h-24 mb-4 font-extrabold tracking-tight lg:text-9xl text-primary-600 dark:text-primary-500"
                            fill="currentColor" viewbox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z"
                                clip-rule="evenodd" />
                        </svg>
                    </div>
                    <p class="mb-4 text-3xl font-bold tracking-tight text-gray-900 md:text-4xl dark:text-white">
                        @lang('visitor-management::visit-locations.info.not-found')
                    </p>
                    @if (count($locations) > 0)
                        <p class="mb-4 text-lg font-light text-gray-500 dark:text-gray-400">
                            @lang('visitor-management::visit-locations.search-result.not-found')
                        </p>
                    @else
                        <p class="mb-4 text-lg font-light text-gray-500 dark:text-gray-400">
                            @lang('visitor-management::visit-locations.info.not-found-description')
                        </p>
                    @endif
                </div>
            </div>
        @endif
    </div>
</div>
