<div x-data="createVisitor" x-cloak x-show="show" id="createVisitorModal" tabindex="-1"
    x-on:show-create-visitor-modal.window="showModal()" x-on:visitor-created.window="created($event)"
    class="fixed top-0 left-0 right-0 z-50 flex items-center justify-center w-full h-screen overflow-x-hidden overflow-y-auto md:inset-0 md:h-full">
    <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75"></div>
    <div class="relative w-full h-full max-w-2xl p-4 md:h-auto">
        <!-- Modal content -->
        <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
            <!-- Modal header -->
            <div class="flex items-center justify-between pb-4 mb-4 border-b rounded-t sm:mb-5 dark:border-gray-600">

                <div class="flex items-center space-x-2 text-gray-900 dark:text-white">
                    {{-- user-plus --}}
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6">
                        <path
                            d="M5.25 6.375a4.125 4.125 0 1 1 8.25 0 4.125 4.125 0 0 1-8.25 0ZM2.25 19.125a7.125 7.125 0 0 1 14.25 0v.003l-.001.119a.75.75 0 0 1-.363.63 13.067 13.067 0 0 1-6.761 1.873c-2.472 0-4.786-.684-6.76-1.873a.75.75 0 0 1-.364-.63l-.001-.122ZM18.75 7.5a.75.75 0 0 0-1.5 0v2.25H15a.75.75 0 0 0 0 1.5h2.25v2.25a.75.75 0 0 0 1.5 0v-2.25H21a.75.75 0 0 0 0-1.5h-2.25V7.5Z" />
                    </svg>

                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        @lang('visitor-management::visit-visitors.modal.add.heading')
                    </h3>
                </div>
                <button x-on:click="hideModal()" type="button"
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">
                        @lang('globals::global.action.close')
                    </span>
                </button>
            </div>
            <!-- Modal body -->
            <div>
                <div class="grid gap-4 mb-4 sm:grid-cols-2">
                    <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="firstname" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-visitors.label.first-name')
                                <x-global-components::global.input-required-hint />
                            </label>
                        </div>
                        <input :disabled="createSucceeded" @keyup.enter="$wire.createVisitor" type="text"
                            wire:model="firstname" id="firstname"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.first-name')" required="">
                        <x-input-error for="firstname" />
                    </div>
                    <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="lastname" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-visitors.label.last-name')
                                <x-global-components::global.input-required-hint />
                            </label>
                        </div>
                        <input :disabled="createSucceeded" @keyup.enter="$wire.createVisitor" type="text"
                            wire:model="lastname" id="lastname"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.last-name')" required="">
                        <x-input-error for="lastname" />
                    </div>
                    <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="email" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('globals::global.label.email')
                                {{-- <x-global-components::global.input-required-hint /> --}}
                            </label>
                        </div>
                        <input :disabled="createSucceeded" @keyup.enter="$wire.createVisitor" type="email"
                            wire:model="email" id="email"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('globals::global.placeholder.email')">
                        <x-input-error for="email" />
                    </div>
                    <div>
                        <div wire:ignore>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="mobilenumber"
                                    class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-visitors.label.mobile-phone-number')
                                </label>
                            </div>
                            <input :disabled="createSucceeded" @keyup.enter="$wire.createVisitor" type="tel"
                                id="create_mobilenumber"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-visitors.placeholder.mobile-phone-number')" required="">
                            <input type="hidden" id="mobilenumber_int" wire:model="mobilenumber" />
                        </div>
                        <x-input-error for="mobilenumber" />
                    </div>
                    <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="company" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-visitors.label.company')
                            </label>
                        </div>
                        <input :disabled="createSucceeded" @keyup.enter="$wire.createVisitor" type="text"
                            wire:model="company" id="company"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.company')" required="">
                        <x-input-error for="company" />
                    </div>
                    <div>
                        <label for="preferredLanguage"
                            class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                            @lang('visitor-management::visit-visitors.label.preferred-language')
                            {{-- <x-global-components::global.input-required-hint /> --}}
                        </label>
                        <select :disabled="createSucceeded" wire:model="preferredLanguage" id="preferredLanguage"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.preferred-language')" required="">
                            {{-- <option>-</option> --}}
                            @foreach ($languages as $language)
                                <option value="{{ $language }}">
                                    @lang("globals::global.languages.$language")
                                </option>
                            @endforeach
                        </select>
                        <x-input-error for="preferredLanguage" />
                    </div>
                    {{-- <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="birthday" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-visitors.label.date-of-birth')
                                <x-global-components::global.input-required-hint />
                            </label>
                        </div>
                        <input :disabled="createSucceeded" @keyup.enter="$wire.createVisitor" type="date"
                            wire:model="birthday" id="birthday"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.date-of-birth')" required="">
                        <x-input-error for="birthday" />
                    </div>

                    <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="country" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-visitors.label.country')
                                <x-global-components::global.input-required-hint />
                            </label>
                        </div>
                        <input :disabled="createSucceeded" @keyup.enter="$wire.createVisitor" type="text"
                            wire:model="country" id="country"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.country')" required="">
                        <x-input-error for="country" />
                    </div>
                    <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="postcode" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-visitors.label.zip-code')
                                <x-global-components::global.input-required-hint />
                            </label>
                        </div>
                        <input :disabled="createSucceeded" @keyup.enter="$wire.createVisitor" type="text"
                            wire:model="postcode" id="postcode"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.zip-code')" required="">
                        <x-input-error for="postcode" />
                    </div>
                    <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="street" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-visitors.label.street')
                                <x-global-components::global.input-required-hint />
                            </label>
                        </div>
                        <input :disabled="createSucceeded" @keyup.enter="$wire.createVisitor" type="text"
                            wire:model="street" id="street"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.street')" required="">
                        <x-input-error for="street" />
                    </div>
                    <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="housenumber" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-visitors.label.house-number')
                                <x-global-components::global.input-required-hint />
                            </label>
                        </div>
                        <input :disabled="createSucceeded" @keyup.enter="$wire.createVisitor" type="text"
                            wire:model="housenumber" id="housenumber"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.house-number')" required="">
                        <x-input-error for="housenumber" />
                    </div>
                    <div class="flex items-center col-start-1">
                        <input :disabled="createSucceeded" type="checkbox" wire:model="hasSafetyBriefing"
                            id="hasSafetyBriefing"
                            class="w-4 h-4 bg-gray-100 border-gray-300 rounded text-primary-600 focus:ring-primary-500 dark:focus:ring-primary-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.has-safety-briefing')" required="">
                        <label for="hasSafetyBriefing"
                            class="text-sm font-medium text-gray-900 ms-2 dark:text-gray-300">
                            @lang('visitor-management::visit-visitors.label.has-safety-briefing')
                        </label>
                        <x-input-error for="hasSafetyBriefing" />
                    </div> --}}
                </div>
                <div class="flex justify-end">
                    <button wire:loading.remove wire:target="createVisitor" wire:click="createVisitor" type="button"
                        class="text-white inline-flex items-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                        <svg class="w-6 h-6 mr-1 -ml-1" fill="currentColor" viewBox="0 0 20 20"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M10 5a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3H6a1 1 0 110-2h3V6a1 1 0 011-1z"
                                clip-rule="evenodd"></path>
                        </svg>
                        @lang('globals::global.action.add')
                    </button>
                    <x-global-components::global.loading-spinner wire:loading wire:target="createVisitor" />
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('createVisitor', () => ({
                show: false,
                createSucceeded: false,
                mobilenumberInput: document.querySelector("#create_mobilenumber"),
                intlTelMobilenumberInput: null,

                init() {
                    this.intlTelMobilenumberInput = intlTelInput(this.mobilenumberInput, {
                        utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@24.3.4/build/js/utils.js",
                        initialCountry: "de",
                        validationNumberType: "MOBILE",
                        autoPlaceholder: "aggressive",
                        formatOnDisplay: true,
                        separateDialCode: true,
                    });

                    this.mobilenumberInput.addEventListener('keyup', () => {
                        let number = this.intlTelMobilenumberInput.getNumber();
                        let countryData = this.intlTelMobilenumberInput.getSelectedCountryData();
                        @this.mobilenumberDialCode = countryData.dialCode;
                        @this.mobilenumber = number;
                    });
                },

                // CREATE
                created(event) {
                    this.createSucceeded = true;
                    this.hideModal();
                },
                resetModal() {
                    this.createSucceeded = false;
                    this.intlTelMobilenumberInput.setNumber("");

                    @this.resetModal()
                },
                hideModal() {
                    this.show = false;
                    this.resetModal();
                },
                showModal(id) {
                    this.show = true;

                    setTimeout(() => {
                        document.getElementById('firstname').focus();
                    }, 100);
                }
            }));
        });
    </script>
</div>
