<div x-data="editVisitor" x-cloak x-show="show" id="editVisitorModal" tabindex="-1"
    x-on:show-edit-visitor-modal.window="showModal($event)" x-on:visitor-edited.window="edited($event)"
    x-on:visitor-deleted.window="deleted($event)"
    class="fixed top-0 left-0 right-0 z-50 flex items-center justify-center w-full h-screen overflow-x-hidden overflow-y-auto md:inset-0 md:h-full">
    <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75"></div>
    <div class="relative w-full h-full max-w-2xl p-4 md:h-auto">
        <!-- Modal content -->
        <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
            <!-- Modal header -->
            <div class="flex items-center justify-between pb-4 mb-4 border-b rounded-t sm:mb-5 dark:border-gray-600">

                <div class="flex items-center space-x-2 text-gray-900 dark:text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-5">
                        <path fill-rule="evenodd"
                            d="M7.5 6a4.5 4.5 0 1 1 9 0 4.5 4.5 0 0 1-9 0ZM3.751 20.105a8.25 8.25 0 0 1 16.498 0 .75.75 0 0 1-.437.695A18.683 18.683 0 0 1 12 22.5c-2.786 0-5.433-.608-7.812-1.7a.75.75 0 0 1-.437-.695Z"
                            clip-rule="evenodd" />
                    </svg>
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        @lang('visitor-management::visit-visitors.modal.edit.heading')
                    </h3>
                </div>
                <button x-on:click="hideModal()" type="button"
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">
                        @lang('globals::global.action.close')
                    </span>
                </button>
            </div>
            <!-- Modal body -->
            <div>
                @if (($visitor?->verified ?? true) == false)
                    <div id="alert-additional-content-2"
                        class="p-4 mb-4 text-red-800 border border-red-300 rounded-lg bg-red-50 dark:bg-gray-800 dark:text-red-400 dark:border-red-800"
                        role="alert">
                        <div class="flex items-center">
                            <svg class="shrink-0 w-4 h-4 me-2" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                fill="currentColor" viewBox="0 0 20 20">
                                <path
                                    d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z" />
                            </svg>
                            <span class="sr-only">Info</span>
                            <h3 class="text-lg font-medium">
                                @lang('globals::global.heading.attention')
                            </h3>
                        </div>
                        <div class="mt-2 mb-4 text-sm">
                            @lang('visitor-management::visit-visitors.info.not-verified-description')
                        </div>
                        <div class="flex">
                            <button wire:click="verifyVisitor" type="button"
                                class="text-white bg-red-800 hover:bg-red-900 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-xs px-3 py-1.5 me-2 text-center inline-flex items-center dark:bg-red-600 dark:hover:bg-red-700 dark:focus:ring-red-800">
                                <svg class="me-2 h-3 w-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                    fill="currentColor" viewBox="0 0 20 14">
                                    <path
                                        d="M10 0C4.612 0 0 5.336 0 7c0 1.742 3.546 7 10 7 6.454 0 10-5.258 10-7 0-1.664-4.612-7-10-7Zm0 10a3 3 0 1 1 0-6 3 3 0 0 1 0 6Z" />
                                </svg>
                                @lang('globals::global.action.verify')
                            </button>
                        </div>
                    </div>
                @endif
                <div class="grid gap-4 mb-4 sm:grid-cols-2">
                    <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="firstname" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-visitors.label.first-name')
                                <x-global-components::global.input-required-hint />
                            </label>
                        </div>
                        <input :disabled="editSucceeded || isVisitorAnonymized" @keyup.enter="$wire.editVisitor"
                            type="text" wire:model="firstname" id="firstname"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.first-name')" required="">
                        <x-input-error for="firstname" />
                    </div>
                    <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="lastname" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-visitors.label.last-name')
                                <x-global-components::global.input-required-hint />
                            </label>
                        </div>
                        <input :disabled="editSucceeded || isVisitorAnonymized" @keyup.enter="$wire.editVisitor"
                            type="text" wire:model="lastname" id="lastname"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.last-name')" required="">
                        <x-input-error for="lastname" />
                    </div>
                    <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="email" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('globals::global.label.email')
                                {{-- <x-global-components::global.input-required-hint /> --}}
                            </label>
                        </div>
                        <input :disabled="editSucceeded || isVisitorAnonymized" @keyup.enter="$wire.editVisitor"
                            type="email" wire:model="email" id="email"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('globals::global.placeholder.email')" required="">
                        <x-input-error for="email" />
                    </div>
                    <div>
                        <div wire:ignore>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="mobilenumber"
                                    class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-visitors.label.mobile-phone-number')
                                </label>
                            </div>
                            <input :disabled="editSucceeded || isVisitorAnonymized" @keyup.enter="$wire.editVisitor"
                                type="tel" id="edit_mobilenumber"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-visitors.placeholder.mobile-phone-number')" required="">
                            <input type="hidden" id="mobilenumber_int" wire:model="mobilenumber" />
                        </div>
                        <x-input-error for="mobilenumber" />
                    </div>
                    <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="company" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-visitors.label.company')
                            </label>
                        </div>
                        <input :disabled="editSucceeded || isVisitorAnonymized" @keyup.enter="$wire.editVisitor"
                            type="text" wire:model="company" id="company"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.company')" required="">
                        <x-input-error for="company" />
                    </div>
                    <div>
                        <label for="preferredLanguage"
                            class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                            @lang('visitor-management::visit-visitors.label.preferred-language')
                            {{-- <x-global-components::global.input-required-hint /> --}}
                        </label>
                        <select :disabled="editSucceeded || isVisitorAnonymized" wire:model="preferredLanguage"
                            id="preferredLanguage"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.preferred-language')" required="">
                            {{-- <option>-</option> --}}
                            @foreach ($languages as $language)
                                <option value="{{ $language }}">
                                    @lang("globals::global.languages.$language")
                                </option>
                            @endforeach
                        </select>
                        <x-input-error for="preferredLanguage" />
                    </div>
                    {{-- <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="birthday" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-visitors.label.date-of-birth')
                                <x-global-components::global.input-required-hint />
                            </label>
                        </div>
                        <input :disabled="editSucceeded" @keyup.enter="$wire.editVisitor" type="date"
                            wire:model="birthday" id="birthday"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.date-of-birth')" required="">
                        <x-input-error for="birthday" />
                    </div>

                    <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="country" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-visitors.label.country')
                                <x-global-components::global.input-required-hint />
                            </label>
                        </div>
                        <input :disabled="editSucceeded" @keyup.enter="$wire.editVisitor" type="text"
                            wire:model="country" id="country"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.country')" required="">
                        <x-input-error for="country" />
                    </div>
                    <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="postcode" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-visitors.label.zip-code')
                                <x-global-components::global.input-required-hint />
                            </label>
                        </div>
                        <input :disabled="editSucceeded" @keyup.enter="$wire.editVisitor" type="text"
                            wire:model="postcode" id="postcode"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.zip-code')" required="">
                        <x-input-error for="postcode" />
                    </div>
                    <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="street" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-visitors.label.street')
                                <x-global-components::global.input-required-hint />
                            </label>
                        </div>
                        <input :disabled="editSucceeded" @keyup.enter="$wire.editVisitor" type="text"
                            wire:model="street" id="street"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.street')" required="">
                        <x-input-error for="street" />
                    </div>
                    <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="housenumber" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-visitors.label.house-number')
                                <x-global-components::global.input-required-hint />
                            </label>
                        </div>
                        <input :disabled="editSucceeded" @keyup.enter="$wire.editVisitor" type="text"
                            wire:model="housenumber" id="housenumber"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.house-number')" required="">
                        <x-input-error for="housenumber" />
                    </div>
                    <div class="flex items-center col-start-1">
                        <input :disabled="editSucceeded" type="checkbox" wire:model="hasSafetyBriefing"
                            id="hasSafetyBriefing"
                            class="w-4 h-4 bg-gray-100 border-gray-300 rounded text-primary-600 focus:ring-primary-500 dark:focus:ring-primary-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600"
                            placeholder="@lang('visitor-management::visit-visitors.placeholder.has-safety-briefing')" required="">
                        <label for="hasSafetyBriefing"
                            class="text-sm font-medium text-gray-900 ms-2 dark:text-gray-300">
                            @lang('visitor-management::visit-visitors.label.has-safety-briefing')
                        </label>
                        <x-input-error for="hasSafetyBriefing" />
                    </div> --}}
                </div>
                <div x-cloak x-show="!editSucceeded" class="flex justify-between">
                    <div class="flex items-center">
                        <button x-show="!showRemove" class="text-red-600 dark:text-red-500 hover:underline"
                            x-on:click="showRemove = true">
                            @lang('globals::global.action.delete')
                        </button>
                        <div x-cloak x-show="showRemove" wire:loading.remove wire:target="deleteVisitor">
                            <p class="text-xs text-gray-900 dark:text-white">
                                @lang('globals::global.confirm.delete')</p>
                            <div>
                                <button x-on:click="showRemove = false"
                                    class="font-medium text-fkbgreen-700 dark:text-fkbgreen-600 hover:underline">
                                    @lang('globals::global.action.cancel')
                                </button>
                                <button x-on:click="showRemove = false" wire:click="deleteVisitor"
                                    class="font-medium text-red-600 dark:text-red-500 hover:underline">
                                    @lang('globals::global.action.delete')
                                </button>
                            </div>
                        </div>
                    </div>
                    @if (($visitor?->anonymized ?? true) == false)
                        <button -show="!editSucceeded" wire:loading.remove wire:target="editVisitor, deleteVisitor"
                            wire:click="editVisitor" type="button"
                            class="text-white inline-flex items-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                class="w-5 h-5 mr-1 -ml-1">
                                <path fill-rule="evenodd"
                                    d="M19.916 4.626a.75.75 0 0 1 .208 1.04l-9 13.5a.75.75 0 0 1-1.154.114l-6-6a.75.75 0 0 1 1.06-1.06l5.353 5.353 8.493-12.74a.75.75 0 0 1 1.04-.207Z"
                                    clip-rule="evenodd" />
                            </svg>
                            @lang('globals::global.action.save')
                        </button>
                    @endif
                    <x-global-components::global.loading-spinner wire:loading wire:target="editVisitor" />
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('editVisitor', () => ({
                show: false,
                editSucceeded: false,
                showRemove: false,
                mobilenumberInput: document.querySelector("#edit_mobilenumber"),
                intlTelMobilenumberInput: null,
                isVisitorAnonymized: false,

                setMobilenumber: (intlTelMobilenumberInput) => {
                    let number = intlTelMobilenumberInput.getNumber();
                    let countryData = intlTelMobilenumberInput.getSelectedCountryData();
                    @this.mobilenumberDialCode = countryData.dialCode;
                    @this.mobilenumber = number;
                },

                init() {
                    this.intlTelMobilenumberInput = intlTelInput(this.mobilenumberInput, {
                        utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@24.3.4/build/js/utils.js",
                        initialCountry: "de",
                        validationNumberType: "MOBILE",
                        autoPlaceholder: "aggressive",
                        formatOnDisplay: true,
                        separateDialCode: true,
                    });

                    this.mobilenumberInput.addEventListener('keyup', function() {
                        this.setMobilenumber(this.intlTelMobilenumberInput);
                    });

                    this.mobilenumberInput.addEventListener("countrychange", () => {
                        this.setMobilenumber(this.intlTelMobilenumberInput);
                    });
                },

                edited(event) {
                    this.editSucceeded = true;
                    this.hideModal();
                },
                deleted(event) {
                    this.editSucceeded = true;
                    this.hideModal();
                },
                resetModal() {
                    this.editSucceeded = false;
                    this.showRemove = false;
                    this.intlTelMobilenumberInput.setNumber("");

                    @this.resetModal()
                },
                hideModal() {
                    this.show = false;
                    this.resetModal();
                },
                showModal(event) {
                    this.show = true;
                    this.isVisitorAnonymized = event.detail.visitor.anonymized;

                    this.intlTelMobilenumberInput.setNumber(event.detail.visitor.mobile_phone_number);
                    let countryData = this.intlTelMobilenumberInput.getSelectedCountryData();
                    @this.mobilenumberDialCode = countryData.dialCode;
                    @this.mobilenumber = event.detail.visitor.mobile_phone_number;

                    setTimeout(() => {
                        document.getElementById('firstname').focus();
                    }, 100);
                }
            }));
        });
    </script>
</div>
