<div x-data="personalize" x-on:appointment-personalized.window="personalized($event)">

    <section x-show="tab == 'personalize'" class="px-8 bg-white rounded-xl dark:bg-gray-900">
        <div class="py-8 mx-auto lg:py-16">
            <div class="flex justify-center">
                <button type="button" data-dropdown-toggle="language-dropdown"
                    class="inline-flex justify-center items-center p-2 text-gray-500 rounded cursor-pointer dark:hover:text-white dark:text-gray-400 hover:text-gray-900 hover:bg-gray-100 dark:hover:bg-gray-600">
                    <span class="rounded fi fi-{{ __('globals::global.iso-3166-1-alpha-2', [], app()->getLocale()) }}"></span>
                </button>
                <!-- Dropdown -->
                <div class="hidden z-50 my-4 text-base list-none bg-white rounded divide-y divide-gray-100 shadow dark:bg-gray-700"
                    id="language-dropdown">
                    <ul class="py-1" role="none">
                        @foreach (config('app.locales') as $locale => $language)
                            <li>
                                <a href="{{ route('locale.set', ['locale' => $locale]) }}"
                                    class="block py-2 px-4 text-sm text-gray-700 hover:bg-gray-100 dark:hover:text-white dark:text-gray-300 dark:hover:bg-gray-600"
                                    role="menuitem">
                                    <div class="inline-flex items-center space-x-2">
                                        <span
                                            class="rounded fi fi-{{ __('globals::global.iso-3166-1-alpha-2', [], $locale) }}"></span>
                                        <p>
                                            {{ __('globals::global.language', [], $locale) }}
                                        </p>
                                    </div>
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
            <h2 class="mb-4 text-4xl font-extrabold tracking-tight text-center text-gray-900 dark:text-white">
                @lang('visitor-management::personalization.page.heading')
            </h2>
            <p class="mb-8 font-light text-center text-gray-500 lg:mb-16 dark:text-gray-400 sm:text-xl">
                @lang('visitor-management::personalization.page.description')
            </p>
            <div class="flex mb-8 space-x-4">
                {{-- DATE --}}
                <div class="flex space-x-1">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-7">
                        <path
                            d="M12.75 12.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM7.5 15.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM8.25 17.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM9.75 15.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM10.5 17.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM12 15.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM12.75 17.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM14.25 15.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM15 17.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM16.5 15.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM15 12.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM16.5 13.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z" />
                        <path fill-rule="evenodd"
                            d="M6.75 2.25A.75.75 0 0 1 7.5 3v1.5h9V3A.75.75 0 0 1 18 3v1.5h.75a3 3 0 0 1 3 3v11.25a3 3 0 0 1-3 3H5.25a3 3 0 0 1-3-3V7.5a3 3 0 0 1 3-3H6V3a.75.75 0 0 1 .75-.75Zm13.5 9a1.5 1.5 0 0 0-1.5-1.5H5.25a1.5 1.5 0 0 0-1.5 1.5v7.5a1.5 1.5 0 0 0 1.5 1.5h13.5a1.5 1.5 0 0 0 1.5-1.5v-7.5Z"
                            clip-rule="evenodd" />
                    </svg>
                    <p class="text-xl">
                        {{ $appointment->valid_from->format(__('globals::global.date.format')) }}
                    </p>
                </div>
                {{-- TIME --}}
                <div class="flex space-x-1">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                        stroke="currentColor" class="size-7">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M12 6v6h4.5m4.5 0a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
                    </svg>
                    <p class="text-xl">
                        {{ $appointment->valid_from->format(__('globals::global.time.format')) }}
                    </p>
                </div>
            </div>
            <div class="space-y-8 sm:grid sm:grid-cols-3 sm:gap-8">
                <div class="sm:col-span-2">
                    {{-- PERSONALIZATION --}}
                    <div class="grid grid-cols-2 gap-2">
                        <div>
                            <label for="firstname"
                                class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                                @lang('visitor-management::personalization.label.first-name')
                            </label>
                            <input type="text" id="firstname" wire:model="firstname"
                                class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500 dark:shadow-sm-light"
                                placeholder="@lang('visitor-management::personalization.placeholder.first-name')" required>
                            <x-input-error for="firstname" />
                        </div>
                        <div>
                            <label for="lastname"
                                class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                                @lang('visitor-management::personalization.label.last-name')
                            </label>
                            <input type="text" id="lastname" wire:model="lastname"
                                class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500 dark:shadow-sm-light"
                                placeholder="@lang('visitor-management::personalization.placeholder.last-name')" required>
                            <x-input-error for="lastname" />
                        </div>
                        <div>
                            <label for="email"
                                class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                                @lang('visitor-management::personalization.placeholder.email')
                            </label>
                            <input type="email" id="email" wire:model="email"
                                class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500 dark:shadow-sm-light"
                                placeholder="name@email.com" required>
                            <x-input-error for="email" />
                        </div>
                        <div>
                            <div wire:ignore>
                                <label for="mobilenumber"
                                    class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                                    @lang('visitor-management::personalization.label.mobile-phone-number')
                                </label>
                                <input :disabled="editSucceeded" @keyup.enter="$wire.editVisitor" type="tel"
                                    id="personalize_mobilenumber"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                    placeholder="@lang('visitor-management::personalization.placeholder.mobile-phone-number')" required="">
                                <input type="hidden" id="mobilenumber_int" wire:model="mobilenumber" />
                            </div>
                            <x-input-error for="mobilenumber" />
                        </div>
                        {{-- <div>
                            <label for="birthday"
                                class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                                @lang('visitor-management::personalization.label.date-of-birth')
                            </label>
                            <input type="date" id="birthday"
                                class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500 dark:shadow-sm-light"
                                placeholder="@lang('visitor-management::personalization.placeholder.date-of-birth')" required>
                        </div>
                        <div>
                            <label for="country"
                                class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                                @lang('visitor-management::personalization.label.country')
                            </label>
                            <input type="text" id="country"
                                class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500 dark:shadow-sm-light"
                                placeholder="@lang('visitor-management::personalization.placeholder.country')" required>
                        </div>
                        <div>
                            <label for="postcode"
                                class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                                @lang('visitor-management::personalization.label.zip-code')
                            </label>
                            <input type="text" id="postcode"
                                class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500 dark:shadow-sm-light"
                                placeholder="@lang('visitor-management::personalization.placeholder.zip-code')" required>
                        </div>
                        <div>
                            <label for="street"
                                class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                                @lang('visitor-management::personalization.label.street')
                            </label>
                            <input type="text" id="street"
                                class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500 dark:shadow-sm-light"
                                placeholder="@lang('visitor-management::personalization.placeholder.street')" required>
                        </div>
                        <div>
                            <label for="housenumber"
                                class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                                @lang('visitor-management::personalization.label.house-number')
                            </label>
                            <input type="text" id="housenumber"
                                class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500 dark:shadow-sm-light"
                                placeholder="@lang('visitor-management::personalization.placeholder.house-number')" required>
                        </div> --}}
                        @if($appointment?->drive_on_area_permitted)
                        {{-- @foreach ($appointmentVehicles as $index => $vehicle) --}}
                        <div class="col-start-1">
                            <div>
                                <div class="flex items-center mb-2 space-x-1">
                                    <label for="lastname" class="block text-sm font-medium text-gray-900 dark:text-white">
                                        @lang('visitor-management::personalization.label.license-plate')
                                        <x-global-components::global.input-required-hint />
                                    </label>
                                </div>
                                <input :disabled="editSucceeded" type="text"
                                    wire:model="licensePlate" id="function"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                    placeholder="@lang('visitor-management::personalization.placeholder.license-plate')" required="">
                                <x-input-error for="licensePlate" />
                            </div>
                        </div>
                        {{-- @endforeach --}}
                        @endif
                    </div>


                    @if($appointment->visitType->identifier == \BplanModules\VisitorManagement\Enums\VisitTypeIdentifier::GroupVisit)
                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-300">
                        @lang('visitor-management::personalization.info.import-file', [
                            'download_link' => Storage::disk('public')->url('group-visitors-import.xlsx'),
                            'employeeEmail' => $appointment->mainEmployee->email
                        ])
                    </p>
                    @endif

                    {{-- MORE VISITORS --}}
                    <div class="my-4">
                        <ul class="max-w-md divide-y divide-gray-200 dark:divide-gray-700">
                            @foreach ($additionalVisitors as $additionalVisitorIndex => $additionalVisitor)
                                <li class="py-2 sm:py-3">
                                    <div class="flex items-center space-x-4 rtl:space-x-reverse">
                                        <div class="flex-shrink-0">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                fill="currentColor" class="size-8">
                                                <path fill-rule="evenodd"
                                                    d="M18.685 19.097A9.723 9.723 0 0 0 21.75 12c0-5.385-4.365-9.75-9.75-9.75S2.25 6.615 2.25 12a9.723 9.723 0 0 0 3.065 7.097A9.716 9.716 0 0 0 12 21.75a9.716 9.716 0 0 0 6.685-2.653Zm-12.54-1.285A7.486 7.486 0 0 1 12 15a7.486 7.486 0 0 1 5.855 2.812A8.224 8.224 0 0 1 12 20.25a8.224 8.224 0 0 1-5.855-2.438ZM15.75 9a3.75 3.75 0 1 1-7.5 0 3.75 3.75 0 0 1 7.5 0Z"
                                                    clip-rule="evenodd" />
                                            </svg>
                                        </div>
                                        <div class="flex-1 min-w-0">
                                            <p class="text-sm font-medium text-gray-900 truncate dark:text-white">
                                                {{ $additionalVisitor->first_name ?? '' }} {{ $additionalVisitor->last_name ?? '' }}
                                            </p>
                                            <p class="text-sm text-gray-500 truncate dark:text-gray-400">
                                                {{ $additionalVisitor->email ?? ''}}
                                            </p>
                                        </div>
                                        @if (isset($additionalVisitorsAttributes[$additionalVisitorIndex]))
                                            @if (isset($additionalVisitorsAttributes[$additionalVisitorIndex]['__added']) &&
                                                    $additionalVisitorsAttributes[$additionalVisitorIndex]['__added'] === true)
                                                <span
                                                    class="bg-primary-100 text-primary-800 text-xs font-medium me-2 px-2.5 py-0.5 rounded dark:bg-primary-900 dark:text-primary-300">
                                                    @lang('visitor-management::personalization.new_visitor')
                                                </span>
                                            @elseif(
                                                $additionalVisitorsAttributes[$additionalVisitorIndex]['__edited'] &&
                                                    $additionalVisitorsAttributes[$additionalVisitorIndex]['__edited'] === true)
                                                <span
                                                    class="bg-yellow-100 text-yellow-800 text-xs font-medium me-2 px-2.5 py-0.5 rounded dark:bg-yellow-900 dark:text-yellow-300">
                                                    @lang('visitor-management::personalization.edited')
                                                </span>
                                            @endif
                                        @endif
                                        {{-- @if (!isset($additionalVisitor->id) || $additionalVisitor->id < 0)
                                            <div
                                                class="inline-flex items-center text-base font-semibold text-gray-900 dark:text-white">
                                                <button type="button"
                                                    x-on:click="$dispatch('show-edit-visitor-modal', { index: @js($additionalVisitorIndex), visitor: @js($additionalVisitor) })"
                                                    class="inline-flex items-center p-0.5 text-sm font-medium text-center text-gray-500 hover:text-gray-800 rounded-lg focus:outline-none dark:text-gray-400 dark:hover:text-gray-100">
                                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                        viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                        class="w-5 h-5">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                                                    </svg>
                                                </button>
                                            </div>
                                        @else
                                            <x-global-components::global.information-icon :data-tippy-content="__('visitor-management::personalization.not_editable_because_id')" />
                                        @endif --}}
                                        <div x-data="{ showRemove: false }"
                                            class="inline-flex items-center text-base font-semibold text-gray-900 dark:text-white">
                                            <button x-show="!showRemove" type="button"
                                                x-on:click="showRemove = true"
                                                class="inline-flex items-center p-0.5 text-sm font-medium text-center text-gray-500 hover:text-red-500 rounded-lg focus:outline-none dark:text-gray-400 dark:hover:text-red-400">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                    fill="currentColor" class="size-5">
                                                    <path fill-rule="evenodd"
                                                        d="M16.5 4.478v.227a48.816 48.816 0 0 1 3.878.512.75.75 0 1 1-.256 1.478l-.209-.035-1.005 13.07a3 3 0 0 1-2.991 2.77H8.084a3 3 0 0 1-2.991-2.77L4.087 6.66l-.209.035a.75.75 0 0 1-.256-1.478A48.567 48.567 0 0 1 7.5 4.705v-.227c0-1.564 1.213-2.9 2.816-2.951a52.662 52.662 0 0 1 3.369 0c1.603.051 2.815 1.387 2.815 2.951Zm-6.136-1.452a51.196 51.196 0 0 1 3.273 0C14.39 3.05 15 3.684 15 4.478v.113a49.488 49.488 0 0 0-6 0v-.113c0-.794.609-1.428 1.364-1.452Zm-.355 5.945a.75.75 0 1 0-1.5.058l.347 9a.75.75 0 1 0 1.499-.058l-.346-9Zm5.48.058a.75.75 0 1 0-1.498-.058l-.347 9a.75.75 0 0 0 1.5.058l.345-9Z"
                                                        clip-rule="evenodd" />
                                                </svg>
                                            </button>
                                            <div x-cloak x-show="showRemove" wire:loading.remove
                                                wire:target="deleteUser">
                                                <p class="text-xs text-gray-900 dark:text-white">
                                                    @lang('globals::global.confirm.delete')</p>
                                                <div>
                                                    <button x-on:click="showRemove = false"
                                                        wire:click="removeVisitor({{ $additionalVisitorIndex }})"
                                                        class="font-medium text-red-600 dark:text-red-500 hover:underline">
                                                        @lang('globals::global.action.delete')
                                                    </button>
                                                    <button x-on:click="showRemove = false"
                                                        class="font-medium text-fkbgreen-700 dark:text-fkbgreen-600 hover:underline">
                                                        @lang('globals::global.action.cancel')
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            @endforeach
                            {{-- @foreach ($addedVisitors as $addedVisitorIndex => $addedVisitor)
                                <li class="py-2 sm:py-3">
                                    <div class="flex items-center space-x-4 rtl:space-x-reverse">
                                        <div class="flex-shrink-0">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                fill="currentColor" class="size-8">
                                                <path fill-rule="evenodd"
                                                    d="M18.685 19.097A9.723 9.723 0 0 0 21.75 12c0-5.385-4.365-9.75-9.75-9.75S2.25 6.615 2.25 12a9.723 9.723 0 0 0 3.065 7.097A9.716 9.716 0 0 0 12 21.75a9.716 9.716 0 0 0 6.685-2.653Zm-12.54-1.285A7.486 7.486 0 0 1 12 15a7.486 7.486 0 0 1 5.855 2.812A8.224 8.224 0 0 1 12 20.25a8.224 8.224 0 0 1-5.855-2.438ZM15.75 9a3.75 3.75 0 1 1-7.5 0 3.75 3.75 0 0 1 7.5 0Z"
                                                    clip-rule="evenodd" />
                                            </svg>
                                        </div>
                                        <div class="flex-1 min-w-0">
                                            <p class="text-sm font-medium text-gray-900 truncate dark:text-white">
                                                {{ $addedVisitor['first_name'] }} {{ $addedVisitor['last_name'] }}
                                            </p>
                                            <p class="text-sm text-gray-500 truncate dark:text-gray-400">
                                                {{ $addedVisitor['email'] }}
                                            </p>
                                        </div>
                                        <span
                                            class="bg-primary-100 text-primary-800 text-xs font-medium me-2 px-2.5 py-0.5 rounded dark:bg-primary-900 dark:text-primary-300">
                                            @lang('visitor-management::personalization.new_visitor')
                                        </span>
                                        <div
                                            class="inline-flex items-center text-base font-semibold text-gray-900 dark:text-white">
                                            <button type="button"
                                                x-on:click="$dispatch('show-edit-added-visitor-modal', { index: @js($addedVisitorIndex), visitor: @js($addedVisitor) })"
                                                class="inline-flex items-center p-0.5 text-sm font-medium text-center text-gray-500 hover:text-gray-800 rounded-lg focus:outline-none dark:text-gray-400 dark:hover:text-gray-100">
                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                    viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                    class="w-5 h-5">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                                                </svg>
                                            </button>
                                        </div>
                                    </div>
                                </li>
                            @endforeach --}}
                        </ul>
                        <div class="flex items-center my-4">
                            <input type="checkbox" wire:model="safetyBriefing"
                                class="w-4 h-4 text-primary-600 bg-gray-100 border-gray-300 rounded focus:ring-primary-500 dark:focus:ring-primary-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                            <label for="link-checkbox"
                                class="text-sm font-medium text-gray-900 ms-2 dark:text-gray-300">
                                @lang('visitor-management::personalization.confirm.safety-briefing', [
                                    'url' => $safetyBriefingUrl,
                                ])
                            </label>
                        </div>
                        <x-input-error for="safetyBriefing" />
                    </div>
                    <div class="mt-4">
                        <button type="button" wire:click="personalizeAppointment"
                            class="px-5 py-3 text-sm font-medium text-center text-white rounded-lg bg-primary-700 sm:w-fit hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                            @lang('globals::global.action.save')
                        </button>
                    </div>
                </div>
                {{-- COMPANY INFO --}}
                <div class="sm:col-span-1">
                    <div class="grid grid-cols-1 gap-6">
                        <div class="text-center">
                            <div class="flex items-center justify-center">
                                <div class="flex items-center justify-center p-5 bg-gray-200 rounded-lg">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                        class="text-gray-600 size-8">
                                        <path fill-rule="evenodd"
                                            d="M4.5 2.25a.75.75 0 0 0 0 1.5v16.5h-.75a.75.75 0 0 0 0 1.5h16.5a.75.75 0 0 0 0-1.5h-.75V3.75a.75.75 0 0 0 0-1.5h-15ZM9 6a.75.75 0 0 0 0 1.5h1.5a.75.75 0 0 0 0-1.5H9Zm-.75 3.75A.75.75 0 0 1 9 9h1.5a.75.75 0 0 1 0 1.5H9a.75.75 0 0 1-.75-.75ZM9 12a.75.75 0 0 0 0 1.5h1.5a.75.75 0 0 0 0-1.5H9Zm3.75-5.25A.75.75 0 0 1 13.5 6H15a.75.75 0 0 1 0 1.5h-1.5a.75.75 0 0 1-.75-.75ZM13.5 9a.75.75 0 0 0 0 1.5H15A.75.75 0 0 0 15 9h-1.5Zm-.75 3.75a.75.75 0 0 1 .75-.75H15a.75.75 0 0 1 0 1.5h-1.5a.75.75 0 0 1-.75-.75ZM9 19.5v-2.25a.75.75 0 0 1 .75-.75h4.5a.75.75 0 0 1 .75.75v2.25a.75.75 0 0 1-.75.75h-4.5A.75.75 0 0 1 9 19.5Z"
                                            clip-rule="evenodd" />
                                    </svg>
                                </div>
                            </div>
                            <h3 class="my-2 text-xl font-bold dark:text-white">
                                @lang('visitor-management::personalization.company.heading.name')
                            </h3>
                            <p class="text-gray-500 dark:text-gray-400">
                                {{ config('project.company.full_name') }}
                            </p>
                        </div>
                        <div class="text-center">
                            <div class="flex items-center justify-center">
                                <div class="flex items-center justify-center p-5 bg-gray-200 rounded-lg">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                        class="text-gray-600 size-8">
                                        <path fill-rule="evenodd"
                                            d="m11.54 22.351.07.04.028.016a.76.76 0 0 0 .723 0l.028-.015.071-.041a16.975 16.975 0 0 0 1.144-.742 19.58 19.58 0 0 0 2.683-2.282c1.944-1.99 3.963-4.98 3.963-8.827a8.25 8.25 0 0 0-16.5 0c0 3.846 2.02 6.837 3.963 8.827a19.58 19.58 0 0 0 2.682 2.282 16.975 16.975 0 0 0 1.145.742ZM12 13.5a3 3 0 1 0 0-6 3 3 0 0 0 0 6Z"
                                            clip-rule="evenodd" />
                                    </svg>
                                </div>
                            </div>
                            <h3 class="my-2 text-xl font-bold dark:text-white">
                                @lang('visitor-management::personalization.company.heading.address')
                            </h3>
                            <p class="text-gray-500 dark:text-gray-400">
                                {{ config('project.company.address') }}
                            </p>
                        </div>
                        <div class="text-center">
                            <div class="flex items-center justify-center">
                                <div class="flex items-center justify-center p-5 bg-gray-200 rounded-lg">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                        class="text-gray-600 size-8">
                                        <path fill-rule="evenodd"
                                            d="M1.5 4.5a3 3 0 0 1 3-3h1.372c.86 0 1.61.586 1.819 1.42l1.105 4.423a1.875 1.875 0 0 1-.694 1.955l-1.293.97c-.135.101-.164.249-.126.352a11.285 11.285 0 0 0 6.697 6.697c.103.038.25.009.352-.126l.97-1.293a1.875 1.875 0 0 1 1.955-.694l4.423 1.105c.834.209 1.42.959 1.42 1.82V19.5a3 3 0 0 1-3 3h-2.25C8.552 22.5 1.5 15.448 1.5 6.75V4.5Z"
                                            clip-rule="evenodd" />
                                    </svg>
                                </div>
                            </div>
                            <h3 class="my-2 text-xl font-bold dark:text-white">
                                @lang('visitor-management::personalization.company.heading.contact')
                            </h3>

                            @if(!empty($appointment->mainEmployee->phone_number))
                            <a href="tel:{{ $appointment->mainEmployee->phone_number }}" class="font-bold text-primary-600 dark:text-primary-500 hover:underline">
                                @lang('visitor-management::personalization.company.phone-number'): {{ $appointment->mainEmployee->phone_number }} <br>
                            </a>
                            @endif
                            @if(!empty($appointment->mainEmployee->mobile_phone_number))
                            <a href="tel:{{ $appointment->mainEmployee->mobile_phone_number }}" class="font-bold text-primary-600 dark:text-primary-500 hover:underline">
                                @lang('visitor-management::personalization.company.mobile-phone-number'): {{ $appointment->mainEmployee->mobile_phone_number }}
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section x-cloak x-show="tab == 'personalized'" class="px-8 bg-white rounded-xl dark:bg-gray-900">
        <div class="py-8 mx-auto lg:py-16">
            <div class="flex items-center justify-center mb-6">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                    class="text-green-500 size-12">
                    <path fill-rule="evenodd"
                        d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12Zm13.36-1.814a.75.75 0 1 0-1.22-.872l-3.236 4.53L9.53 12.22a.75.75 0 0 0-1.06 1.06l2.25 2.25a.75.75 0 0 0 1.14-.094l3.75-5.25Z"
                        clip-rule="evenodd" />
                </svg>
            </div>

            <h2 class="mb-4 text-4xl font-extrabold tracking-tight text-center text-gray-900 dark:text-white">
                @lang('visitor-management::personalization.finish.heading')
            </h2>
            <p class="mb-8 font-light text-center text-gray-500 lg:mb-16 dark:text-gray-400 sm:text-xl">
                @lang('visitor-management::personalization.finish.description')
            </p>
            <div class="grid gap-6 sm:grid-cols-3">
                <div class="text-center">
                    <div class="flex items-center justify-center">
                        <div class="flex items-center justify-center p-5 bg-gray-200 rounded-lg">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                class="text-gray-600 size-8">
                                <path fill-rule="evenodd"
                                    d="M4.5 2.25a.75.75 0 0 0 0 1.5v16.5h-.75a.75.75 0 0 0 0 1.5h16.5a.75.75 0 0 0 0-1.5h-.75V3.75a.75.75 0 0 0 0-1.5h-15ZM9 6a.75.75 0 0 0 0 1.5h1.5a.75.75 0 0 0 0-1.5H9Zm-.75 3.75A.75.75 0 0 1 9 9h1.5a.75.75 0 0 1 0 1.5H9a.75.75 0 0 1-.75-.75ZM9 12a.75.75 0 0 0 0 1.5h1.5a.75.75 0 0 0 0-1.5H9Zm3.75-5.25A.75.75 0 0 1 13.5 6H15a.75.75 0 0 1 0 1.5h-1.5a.75.75 0 0 1-.75-.75ZM13.5 9a.75.75 0 0 0 0 1.5H15A.75.75 0 0 0 15 9h-1.5Zm-.75 3.75a.75.75 0 0 1 .75-.75H15a.75.75 0 0 1 0 1.5h-1.5a.75.75 0 0 1-.75-.75ZM9 19.5v-2.25a.75.75 0 0 1 .75-.75h4.5a.75.75 0 0 1 .75.75v2.25a.75.75 0 0 1-.75.75h-4.5A.75.75 0 0 1 9 19.5Z"
                                    clip-rule="evenodd" />
                            </svg>
                        </div>
                    </div>
                    <h3 class="my-2 text-xl font-bold dark:text-white">
                        @lang('visitor-management::personalization.heading.company')
                    </h3>
                    <p class="text-gray-500 dark:text-gray-400">
                        {{ config('project.company.full_name') }}
                    </p>
                </div>
                <div class="text-center">
                    <div class="flex items-center justify-center">
                        <div class="flex items-center justify-center p-5 bg-gray-200 rounded-lg">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                class="text-gray-600 size-8">
                                <path fill-rule="evenodd"
                                    d="m11.54 22.351.07.04.028.016a.76.76 0 0 0 .723 0l.028-.015.071-.041a16.975 16.975 0 0 0 1.144-.742 19.58 19.58 0 0 0 2.683-2.282c1.944-1.99 3.963-4.98 3.963-8.827a8.25 8.25 0 0 0-16.5 0c0 3.846 2.02 6.837 3.963 8.827a19.58 19.58 0 0 0 2.682 2.282 16.975 16.975 0 0 0 1.145.742ZM12 13.5a3 3 0 1 0 0-6 3 3 0 0 0 0 6Z"
                                    clip-rule="evenodd" />
                            </svg>
                        </div>
                    </div>
                    <h3 class="my-2 text-xl font-bold dark:text-white">
                        @lang('visitor-management::personalization.heading.address')
                    </h3>
                    <p class="text-gray-500 dark:text-gray-400">
                        {{ config('project.company.address') }}
                    </p>
                </div>
                <div class="text-center">
                    <div class="flex items-center justify-center">
                        <div class="flex items-center justify-center p-5 bg-gray-200 rounded-lg">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                class="text-gray-600 size-8">
                                <path fill-rule="evenodd"
                                    d="M1.5 4.5a3 3 0 0 1 3-3h1.372c.86 0 1.61.586 1.819 1.42l1.105 4.423a1.875 1.875 0 0 1-.694 1.955l-1.293.97c-.135.101-.164.249-.126.352a11.285 11.285 0 0 0 6.697 6.697c.103.038.25.009.352-.126l.97-1.293a1.875 1.875 0 0 1 1.955-.694l4.423 1.105c.834.209 1.42.959 1.42 1.82V19.5a3 3 0 0 1-3 3h-2.25C8.552 22.5 1.5 15.448 1.5 6.75V4.5Z"
                                    clip-rule="evenodd" />
                            </svg>
                        </div>
                    </div>
                    <h3 class="my-2 text-xl font-bold dark:text-white">
                        @lang('visitor-management::personalization.heading.contact')
                    </h3>
                    {{-- <p class="text-gray-500 dark:text-gray-400">
                        Rufen Sie uns bitte nicht an.
                    </p> --}}
                    <a href="tel:{{ config('project.company.phone_number') }}"
                        class="font-bold text-primary-600 dark:text-primary-500 hover:underline">
                        {{ config('project.company.phone_number') }}
                    </a>
                </div>
            </div>
        </div>
    </section>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('personalize', () => ({
                tab: 'personalize',
                editSucceeded: false,
                mobilenumberInput: document.querySelector("#personalize_mobilenumber"),
                intlTelMobilenumberInput: null,

                init() {
                    this.intlTelMobilenumberInput = intlTelInput(this.mobilenumberInput, {
                        utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@24.3.4/build/js/utils.js",
                        initialCountry: "de",
                        validationNumberType: "MOBILE",
                        autoPlaceholder: "aggressive",
                        formatOnDisplay: true,
                        separateDialCode: true,
                    });

                    this.mobilenumberInput.addEventListener('keyup', () => {
                        let number = this.intlTelMobilenumberInput.getNumber();
                        @this.mobilenumber = number;
                    });

                    this.intlTelMobilenumberInput.setNumber(@js($visitor->mobile_phone_number));
                },

                personalized(event) {
                    this.editSucceeded = true;
                    this.tab = 'personalized'
                },
            }));
        });
    </script>
</div>
