<?php
/**
 * Create Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Actions
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Actions\VisitAppointment;


use BplanModules\VisitorManagement\Enums\VisitTypeIdentifier;
use BplanModules\VisitorManagement\Models\VisitAppointment;
use BplanModules\VisitorManagement\Repositories\VisitReasonRepository;
use Carbon\Carbon;


/**
 * Anonymisiert Gruppenbesucher
 *
 * @version     1.0.0 / 2025-03-22
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class AnonymizeBulkVisitors
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Anonymisiert die Bulk-Visitor mit den übergebenen IDs
     *
     * @param       array $visitorIds
     *
     * @return      int
     *
     * @version     1.0.0 / 2025-03-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(array $visitorIds): int
    {
        if (empty($visitorIds)) {
            return 0;
        }
        $VisitReasons = VisitReasonRepository::getByVisitType(VisitTypeIdentifier::BulkAppointment);

        $Appointments = VisitAppointment::whereIn('visit_reason_id', $VisitReasons->pluck('id'))
            ->where(function ($Query) use ($visitorIds) {
                foreach ($visitorIds as $id) {
                    $Query->orWhereJsonContains('visitors', ['id' => (string) $id])
                        ->where(function ($SubQuery) {
                            $SubQuery->whereRaw("JSON_UNQUOTE(JSON_EXTRACT(visitors, '$[*].anonymized')) IS NULL")
                                ->orWhereRaw("JSON_UNQUOTE(JSON_EXTRACT(visitors, '$[*].anonymized')) = '0'");
                        });
                }
            }
        )->get();

        $count = 0;

        foreach ($Appointments as $Appointment) {
            $visitors = collect($Appointment->visitors)->map(function ($visitor) use (& $count, $visitorIds) {
                if (in_array($visitor->id, $visitorIds) === false) {
                    $visitor->anonymized = 1;
                    $visitor->email = null;
                    $visitor->first_name = '*';
                    $visitor->last_name = '*';
                    $visitor->mobile_phone_number = '*';
                    $visitor->mobile_phone_number_country_code = '*';

                    $count++;
                }
                return $visitor;
            });
            $Appointment->visitors = $visitors;

            $Appointment->save();
        }
        return $count;

    } // execute()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class AnonymizeBulkVisitors {}
