<?php
/**
 * Update Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Actions
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Actions\VisitEmployee;


use BplanModules\VisitorManagement\Models\Employee;
use BplanModules\VisitorManagement\Models\User;


/**
 * Update Action Class
 *
 * @version     1.0.0 / 2025-01-08
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UnlinkUser
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       int|string|Employee|User $subject
     *
     * @return      int
     *
     * @version     1.0.0 / 2025-01-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(int|string|Employee|User $subject): int
    {
        if ($subject instanceof User) {
            return Employee::where('user_id', '=', $subject->id)
                ->update([
                    'user_id' => null
                ]);
        }
        if ($subject instanceof Employee) {
            $employeeId = $subject->id;

        } else {
            $employeeId = $subject;
        }
        return Employee::where('id', '=', $employeeId)
            ->update([
                'user_id' => null
            ]);

    } // execute()


} // class UnlinkUser {}
