<?php
/**
 * Create Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-21 22:05:47
 * @package     bplan-modules/visitor-management
 * @subpackage  Actions
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Actions\VisitOpeningHourException;


use BplanBase\Globals\Exceptions\UniqueContraintViolationException;
use BplanModules\VisitorManagement\Models\VisitOpeningHourException;
use BplanModules\VisitorManagement\Repositories\OpeningHourExceptionRepository;


/**
 * Create Action Class
 *
 * @version     1.0.0 / 2025-04-21
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Create
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $attributes
     *
     * @return      VisitOpeningHourException
     *
     * @version     1.0.0 / 2025-04-21
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(array $attributes): VisitOpeningHourException
    {
        $Check = VisitOpeningHourExceptionRepository::getVisitTypeOpeningHourExceptionByDate($attributes['visit_type_id'], $attributes['date']);

        if ($Check !== null) {
            throw new UniqueContraintViolationException('Duplicate entry for visit type ID [#'.$attributes['visit_type_id'].'] on date ['.$attributes['date'].'].');
        }
        $Model = new VisitOpeningHourException();

        $Model->fill($attributes);

        $Model->save();

        return $Model;

    } // execute()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Create {}
