<?php
/**
 * Enum Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Enums
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Enums;


/**
 * Enum Class
 *
 * @version     2.0.0 / 2025-01-19
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
enum VisitReasonDefaultIdentifier: string {

    case AccessAuthorization = 'DefaultAccessAuthorization';

    case BulkAppointment     = 'DefaultBulkAppointment';

    case Contractor          = 'DefaultContractor';

    case Delivery            = 'DefaultDelivery';

    case DeliveryAndPickup   = 'DefaultDeliveryAndPickup';

    case GroupVisit          = 'DefaultGroupVisit';

    case ParcelService       = 'DefaultParcelService';

    case Pickup              = 'DefaultPickup';

    case Shunting            = 'DefaultShunting';

    case SingleVisit         = 'DefaultSingleVisit';

    case Technician          = 'DefaultTechnician';

} // enum VisitReasonDefaultIdentifier {}
