<?php
/**
 * JSON:API Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  ApiControllers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Http\Controllers\Api\Terminal;


use BplanModules\VisitorManagement\Http\Controllers\Controller;
use BplanModules\VisitorManagement\Models\VisitEmployee;
use BplanModules\VisitorManagement\Repositories\VisitContactGroupRepository;
use BplanModules\VisitorManagement\Repositories\VisitEmployeeRepository;
use LaravelJsonApi\Core\Responses\DataResponse;


/**
 * JSON:API Controller Class
 *
 * @version     1.1.0 / 2025-02-05
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ContactController extends Controller
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Ermittelt alle Mitarbeiter zu einer ContactGroup
     *
     * @param       int|string $contactGroupId
     *
     * @return      DataResponse
     *
     * @version     1.1.0 / 2025-02-05
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function index(int|string $contactGroupId): DataResponse
    {
        $ContactGroup = VisitContactGroupRepository::getById($contactGroupId);

        $Query = VisitEmployee::where('active', '=', 1)
            ->where('contact', '=', 1);

        if ($ContactGroup->identifier === 'Emergency') {
            $Query->where('emergency_contact', '=', 1);

        } else {
            $Query->where(function ($Query) use ($contactGroupId) {
                $Query->where('contact_group_id', '=', $contactGroupId)
                     ->orWhere('global_contact', '=', 1);
            });
        }
        $Employees = $Query->orderBy('last_name')
            ->get();

        $contacts = [];

        foreach ($Employees as $Employee) {
            $employeeId = $Employee->id;
            $hasPhone = false;

            if ($Employee->phone_number !== null) {
                $Employee->label = $Employee->last_name.', '.$Employee->first_name;
                $Employee->phone = $Employee->getPhoneNumber();

                $contacts[] = $Employee;

                $hasPhone = true;
            }
            if ($Employee->mobile_phone_number !== null) {
                $NewEmployee = new Employee($Employee->toArray());

                $NewEmployee->id = $employeeId;

                $NewEmployee->label = $NewEmployee->last_name.', '.$NewEmployee->first_name.($hasPhone === true ? ' (Mobil)' : '');
                $NewEmployee->phone = $NewEmployee->getPhoneNumber(getMobile: true);

                $contacts[] = $NewEmployee;
            }
        }
        return DataResponse::make(collect($contacts));

    } // index()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ContactController extends Controller {}
