<?php
/**
 * JSON:API Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  ApiControllers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Http\Controllers\Api\Terminal;


use BplanModules\VisitorManagement\Enums\TokenPrefix;
use BplanModules\VisitorManagement\Http\Controllers\Controller;
use BplanModules\VisitorManagement\Repositories\VisitAppointmentRepository;
use LaravelJsonApi\Core\Responses\DataResponse;
use LaravelJsonApi\Laravel\Http\Controllers\Actions;


/**
 * JSON:API Controller Class
 *
 * @version     3.1.0 / 2024-12-09
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitAppointmentController extends Controller
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

    use Actions\FetchMany;
    // use Actions\FetchOne; // show-Route ist überschrieben
    use Actions\Store;
    use Actions\Update;
    use Actions\Destroy;
    use Actions\FetchRelated;
    use Actions\FetchRelationship;
    use Actions\UpdateRelationship;
    use Actions\AttachRelationship;
    use Actions\DetachRelationship;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Ermittelt ein Appointment über die ID, die OrderNumber oder über das Token
     *
     * @param       int|string $various
     *
     * @return      DataResponse
     *
     * @version     2.1.0 / 2024-12-09
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function show(int|string $various): DataResponse
    {
        if (is_numeric($various)) {
            $Appointment = VisitAppointmentRepository::getModelByID($various, ignoreFinishedStatus: false);

        } else {
            if (substr($various, 0, 2) === 'OA') {
                $various = substr($various, 1);
            }
            if ($various[0] === TokenPrefix::OrderNumber->value) {
                $various = substr($various, 1);

                $Appointment = VisitAppointmentRepository::getModelByOrderNumber($various, ignoreFinishedStatus: false);

            } else {
                $Appointment = VisitAppointmentRepository::getModelByToken($various, ignoreFinishedStatus: false);
            }
        }
        return DataResponse::make($Appointment);

    } // show()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VisitAppointmentController extends Controller {}
