<?php
/**
 * JSON:API Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  ApiControllers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Http\Controllers\Api\Terminal;


use BplanModules\VisitorManagement\Helpers\Collection as CollectionHelper;
use BplanModules\VisitorManagement\Http\Controllers\Controller;
use BplanModules\VisitorManagement\Models\VisitContactGroup;
use BplanModules\VisitorManagement\Models\VisitEmployee;
use LaravelJsonApi\Core\Responses\DataResponse;


/**
 * JSON:API Controller Class
 *
 * @version     1.3.0 / 2025-01-27
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitContactGroupController extends Controller
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Ermittelt alle Mitarbeiter zu einer ContactGroup
     *
     * @return      DataResponse
     *
     * @version     1.3.0 / 2025-01-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function index(): DataResponse
    {
        $Query = VisitContactGroup::where('active', '=', 1);
        /*
        **  IDs der ContactGroups ermitteln, zu denen es auch aktive Employees gibt. */
        $employeeContactGroups = VisitEmployee::where('active', '=', 1)
            ->whereNotNull('contact_group_id')
            ->get()
            ->pluck('contact_group_id')
            ->toArray();

        if (!empty($employeeContactGroups)) {
            /*
            **  Nur wenn es auch Mitarbeiter mit ContactGroups gibt, wird die Auswahl eingeschränkt.
            **  Dass bei fehlenden ContactGroups die uneingeschränkte Liste ermittelt wird, ist
            **  erwünscht (damit es niemals eine leere Liste gibt). */
            $employeeContactGroups = array_unique($employeeContactGroups);

            $Query->whereIn('id', $employeeContactGroups);
        }
        $Collection = $Query->get();

        return DataResponse::make(CollectionHelper::completeLabels($Collection));

    } // index()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VisitContactGroupController extends Controller {}
