<?php
/**
 * JSON:API Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  ApiControllers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Http\Controllers\Api\Terminal;


use BplanModules\VisitorManagement\Helpers\Collection as CollectionHelper;
use BplanModules\VisitorManagement\Http\Controllers\Controller;
use BplanModules\VisitorManagement\Models\VisitContactOption;
use LaravelJsonApi\Core\Responses\DataResponse;


/**
 * JSON:API Controller Class
 *
 * @version     1.0.0 / 2025-01-27
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitContactOptionController extends Controller
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Ermittelt alle Mitarbeiter zu einer ContactGroup
     *
     * @return      DataResponse
     *
     * @version     1.0.0 / 2025-01-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function index(): DataResponse
    {
        $Collection = VisitContactOption::where('active', '=', 1)
            ->get();

        return DataResponse::make(CollectionHelper::completeLabels($Collection));

    } // index()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VisitContactOptionController extends Controller {}
