<?php #CodeGenerator Δ e4a1dfd814925d001775f30f1b034dd2 Δ DYNAMICALLY GENERATED FILE - Do not modify this line! Remove it completely to protect the file from changes.
/**
 * JSON:API Schema Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-06-01 17:02:25
 * @package     bplan-modules/visitor-management
 * @subpackage  Schemas
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\JsonApi\Terminal\VisitVisitors;


use BplanModules\VisitorManagement\Models\VisitVisitor;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use LaravelJsonApi\Eloquent\Contracts\Paginator;
use LaravelJsonApi\Eloquent\Fields\ArrayList;
use LaravelJsonApi\Eloquent\Fields\Boolean;
use LaravelJsonApi\Eloquent\Fields\DateTime;
use LaravelJsonApi\Eloquent\Fields\ID;
use LaravelJsonApi\Eloquent\Fields\Number;
use LaravelJsonApi\Eloquent\Fields\Relations\HasMany;
use LaravelJsonApi\Eloquent\Fields\Str;
use LaravelJsonApi\Eloquent\Filters\WhereIdIn;
use LaravelJsonApi\Eloquent\Pagination\PagePagination;
use LaravelJsonApi\Eloquent\Schema;


/**
 * JSON:API Schema Class
 *
 * @version     2.2.0 / 2025-06-01
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitVisitorSchema extends Schema
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The maximum include path depth.
     *
     * @var int
     */
    protected int $maxDepth = 2;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The model the schema corresponds to.
     *
     * @var         string
     */
    public static string $model = VisitVisitor::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Get the resource fields.
     *
     * @return      array
     *
     * @version     1.3.0 / 2025-06-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function fields(): array
    {

        $timezone = config('app.timezone');

        return [
            ID::make(),

            Boolean::make('active')->sortable(),
            DateTime::make('createdAt')->serializeUsing(
                static fn($value) => $value ? Carbon::parse($value)->setTimezone($timezone)->format('c') : null
            )->readOnly()->sortable(),

            DateTime::make('deletedAt')->serializeUsing(
                static fn($value) => $value ? Carbon::parse($value)->setTimezone($timezone)->format('c') : null
            )->readOnly()->sortable(),

            DateTime::make('updatedAt')->serializeUsing(
                static fn($value) => $value ? Carbon::parse($value)->setTimezone($timezone)->format('c') : null
            )->readOnly()->sortable(),


            Boolean::make('anonymized'),
            Str::make('comments'),
            Str::make('company')->sortable(),
            Str::make('email')->sortable(),
            Str::make('firstName')->sortable(),
            Number::make('importFailureCount')->sortable(),
            ArrayList::make('importFailures'),
            Str::make('lastName')->sortable(),
            Str::make('mobilePhoneNumber'),
            Str::make('mobilePhoneNumberCountryCode'),
            Str::make('preferredLanguage'),
            DateTime::make('safetyBriefingConfirmed')->serializeUsing(
                static fn($value) => $value ? Carbon::parse($value)->setTimezone($timezone)->format('c') : null
            )->sortable(),

            Boolean::make('verified'),
            /*
            **  Relations */
            HasMany::make('assigned-appointments')->type('visit-appointments')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),

        ];
    } // fields()


    /**
     * Get the resource filters.
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-06-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function filters(): array
    {
        return [
            WhereIdIn::make($this),
        ];
    } // filters()


    /**
     * Build an index query for this resource.
     *
     * @param       Request|null $Request
     *
     * @param       Builder $Query
     *
     * @return      Builder

     * @version     1.0.0 / 2025-06-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function indexQuery(?Request $Request, Builder $Query): Builder
    {
        return $Query->where(function (Builder $Query) {
            return $Query;
        });
    } // indexQuery()


    /**
     * Get the resource paginator.
     *
     * @return      null|Paginator
     *
     * @version     1.0.0 / 2025-06-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function pagination(): ?Paginator
    {
        return PagePagination::make();

    } // pagination()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VisitVisitorSchema extends Schema {}
