<?php

namespace BplanModules\VisitorManagement\Livewire\Dashboard;

use BplanModules\VisitorManagement\Enums\ProcessStatus;
use BplanModules\VisitorManagement\Models\VisitAppointment;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class CheckedInAppointments extends Component
{
    protected $listeners = [
        'appointment-checked-out' => 'render',
        'equipment-saved' => 'render',
    ];

    public function render()
    {
        return view('livewire.dashboard.checked-in-appointments', [
            'checkedInAppointments' => $this->getCheckedInAppointments(),
        ]);
    }

    private function getCheckedInAppointments(): LengthAwarePaginator
    {
dd(9);
        $checkedInAppointments = VisitAppointment::where('process_status', '>=', ProcessStatus::Entered->value)
            ->where('process_status', '<', ProcessStatus::CheckedOut->value);
        /*
        **  Nicht jeder User ist auch Mitarbeiter. */
        if (Auth::user()->employee === null) {
            /*
            **  Nur die selbst angelegten Termine des aktuelle Users. */
            $userId = Auth::user()->id;

            $checkedInAppointments->where(function ($query) use ($userId) {
                $query->where('create_user_id', $userId);
            });
        } else {
            /*
            **  Nur die selbst angelegten Termine oder die Termine bei denen der aktuelle User
            **  der verantwortliche Mitarbeiter ist. */
            $employeeId = Auth::user()->employee->id;
            $userId = Auth::user()->id;

            $checkedInAppointments->where(function ($query) use ($employeeId, $userId) {
                $query->where('main_employee_id', $employeeId)
                    ->orWhere('organizer_employee_id', $employeeId)
                    ->orWhere('create_user_id', $userId);
            });
        }

        return $checkedInAppointments->paginate(12);
    }
}
