<?php

namespace BplanModules\VisitorManagement\Livewire\VisitDashboard\Modals;

use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Models\VisitAppointment;
use BplanModules\VisitorManagement\Models\VisitEntryPoint;
use BplanModules\VisitorManagement\Services\VisitAppointmentService;
use Carbon\Carbon;
use Livewire\Attributes\On;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Component;

class CheckOut extends Component
{
    use InteractsWithBanner;

    public ?VisitAppointment $appointment;

    protected LogService $logService;
    protected VisitAppointmentService $appointmentService;

    public function boot(LogService $logService, VisitAppointmentService $appointmentService)
    {
        $this->logService = $logService;
        $this->appointmentService = $appointmentService;
    }

    public function render()
    {
        return view('visitor-management::livewire.visit-dashboard.modals.check-out');
    }

    #[On('show-check-out-modal')]
    public function initAppointment(VisitAppointment $appointment)
    {
        $this->appointment = $appointment;
    }

    public function checkOut()
    {
        try {
            $EntryPoint = VisitEntryPoint::where('token', '=', 'EP0000')
                ->first();

            $this->appointmentService->setProcessStatusCheckedOut($this->appointment->id, [
                'check_out_entry_point_id' => $EntryPoint->id,
            ]);
            $this->logService->log(LogLevel::Info, "Appointment {$this->appointment->subject} checked out by " . auth()->user()->name . ' (' . auth()->user()->email . ')');

            $this->dispatch('init-tippyjs');
            $this->dispatch('appointment-checked-out');
        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'Locations/Modals/editEmployee error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when editing employee. Check the logs for more information.');
        }
    }
}
