<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:42
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitDocuments\Modals;


use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Enums\LanguageContext;
use BplanModules\VisitorManagement\Enums\VisitTypeGroupIdentifier;
use BplanModules\VisitorManagement\Models\VisitLanguage;
use BplanModules\VisitorManagement\Models\VisitType;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Validation\Rule;
use Livewire\Component;
use Livewire\WithFileUploads;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Upload extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use WithFileUploads;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @var [type]
     */
    public $documentFile;


    /**
     *
     * @var string
     */
    public string $documentName;


    /**
     *
     * @var string
     */
    public string $fileLanguage = '';


    /**
     *
     * @var string
     */
    public string $fileType = '';


    /**
     *
     * @var array
     */
    public array $fileTypes;


    /**
     *
     * @var array
     */
    public array $languages;


    /**
     *
     * @var LogService
     */
    protected LogService $logService;


    /**
     *
     * @var string
     */
    public string $uploadSuccessMessage;


    /**
     *
     * @var string
     */
    public string $visitType;


    /**
     *
     * @var [type]
     */
    public $visitTypesGroup;


    /**
     *
     * @var Collection|null
     */
    public ?Collection $visitTypes;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getDocumentName()
    {
        if (!empty($this->fileType) && !empty($this->fileLanguage)) {
            $filename = '';

            switch ($this->fileType) {
                case 'safety-briefing':
                    $filename = $this->_getFilenameForSafetyBriefing();
                    break;

                default:
                    $filename = "{$this->fileType}.{$this->fileLanguage}";
                    break;
            }
            return "{$filename}.pdf";
        } else {
            return '';
        }
    } // _getDocumentName()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getFilenameForSafetyBriefing()
    {
        $filename = "{$this->fileType}.general.{$this->fileLanguage}";

        if(!empty($this->visitTypesGroup))
        {
            $filename = "{$this->fileType}.{$this->visitTypesGroup}.{$this->fileLanguage}";
        }
        elseif (!empty($this->visitTypesGroup) && !empty($this->visitType))
        {
            $filename = "{$this->fileType}.{$this->visitTypesGroup}.{$this->visitType}.{$this->fileLanguage}";
        }

        return $filename;

    } // _getFilenameForSafetyBriefing()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(LogService $logService)
    {
        $this->logService = $logService;

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount()
    {
        $this->fileTypes = [
            'route-description',
            'safety-briefing',
        ];
        $this->languages = VisitLanguage::where('context', '&', LanguageContext::Both->value)->get()->pluck('code')->toArray();

    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('visitor-management::livewire.visit-documents.modals.upload');

    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function resetModal()
    {
        $this->fileType = '';
        $this->fileLanguage = '';
        $this->uploadSuccessMessage = "";
        $this->documentFile = null;

    } // resetModal()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function rules()
    {
        return [
            'fileType' => [
                'required',
                Rule::in($this->fileTypes),
            ],
            'fileLanguage' => [
                'required',
                Rule::in($this->languages),
            ],
            'documentFile' => [
                'required',
            ],
        ];
    } // rules()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updated()
    {
        $this->documentName = $this->_getDocumentName();

        $this->visitTypes = VisitType::where('visit_group', $this->visitTypesGroup)->get();

    } // updated()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function uploadDocument()
    {
        $this->validate();

        try {
            if (isset($this->documentFile)) {
                $this->logService->log(LogLevel::Info, "Starting employees upload.");
                $this->documentFile->storeAs('/', $this->_getDocumentName(), 'attachments');
                // $import = new EmployeesImport(ImportContext::Upload);
                // $import->setAppointmentID($this->appointment->id);
                // $import->importFile($this->documentFile->getRealPath());
                $this->logService->log(LogLevel::Info, "Document upload finished.");

                $this->uploadSuccessMessage = trans('visitor-management::visit-documents.document_successfully_uploaded'); //trans('visitor-management::personalization.visitors_imported_successfully', ['count' => $import->getRowCountSaved()]);

                $this->dispatch('document-uploaded');
            }
        } catch (\Throwable $th) {
            $this->addError('documentFile', trans('visitor-management::visit-documents.error_while_uploading') . $th->getMessage());
        }
    } // uploadDocument()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Upload extends Component {}
