<?php

namespace BplanModules\VisitorManagement\Livewire\VisitLogisticQueue;

use BplanModules\VisitorManagement\Enums\ProcessStatus;
use BplanModules\VisitorManagement\Enums\VisitTypeGroupIdentifier;
use BplanModules\VisitorManagement\Enums\VisitTypeIdentifier;
use BplanModules\VisitorManagement\Models\VisitAppointment;
use Livewire\Component;
use Livewire\WithPagination;

class Index extends Component
{
    use WithPagination;

    protected $listeners = [
        'appointment-checked-out' => 'render',
        'logistic-queue-edited' => 'render',
        'loading-ramp-edited' => 'render',
    ];

    public function render()
    {
        return view('visitor-management::livewire.visit-logistic-queue.index', [
            'queue' => $this->getLogisticQueue(),
        ]);
    }

    private function getLogisticQueue()
    {
        $queue = VisitAppointment::query()
            ->where('process_status', '>=', ProcessStatus::CheckedIn->value)
            ->where('process_status', '<', ProcessStatus::CheckedOut->value)
            ->whereRelation('visitType', function($query) {
                /*
                    todo    Nochmal pr�fen ob es auch ohne den Tabellennamen geht.
                */
                $query->whereIn('visit_types.identifier', [
                    VisitTypeIdentifier::Delivery->value,
                    VisitTypeIdentifier::Pickup->value,
                    VisitTypeIdentifier::DeliveryAndPickup->value,
                ]);
            })
            ->whereRelation('visitType', 'visit_group', '=', VisitTypeGroupIdentifier::Logistics)
            ->orWhereNull('visit_reason_id') // TODOD: workaround solange das Terminal nicht bei Logistik, Abholung oder Anlieferung schickt
            ->orderBy('checked_in_at', 'DESC');

        return $queue->paginate(12);
    }

    public function refreshQueue()
    {
        $this->getLogisticQueue();
    }
}
