<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:42
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitLogisticQueue\Modals;

use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Models\VisitAppointment;
use BplanModules\VisitorManagement\Models\VisitEquipmentItem;
use BplanModules\VisitorManagement\Repositories\VisitEquipmentItemRepository;
use BplanModules\VisitorManagement\Services\VisitAppointmentEquipmentItemService;
use BplanModules\VisitorManagement\Services\VisitAppointmentService;
use Illuminate\Database\Eloquent\Collection;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Attributes\On;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class EditEquipmentItems extends Component
{
    use InteractsWithBanner;


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @var VisitAppointment|null
     */
    public ?VisitAppointment $appointment;


    /**
     *
     * @var array
     */
    public array $appointmentEquipmentItems = [];


    /**
     *
     * @var VisitAppointmentEquipmentItemService
     */
    protected VisitAppointmentEquipmentItemService $appointmentEquipmentItemService;


    /**
     *
     * @var VisitAppointmentService
     */
    protected VisitAppointmentService $appointmentService;


    /**
     *
     * @var Collection|null
     */
    public ?Collection $equipmentItems;


    /**
     *
     * @var LogService
     */
    protected LogService $logService;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(LogService $logService, VisitAppointmentService $appointmentService, VisitAppointmentEquipmentItemService $appointmentEquipmentItemService)
    {
        $this->logService = $logService;
        $this->appointmentService = $appointmentService;
        $this->appointmentEquipmentItemService = $appointmentEquipmentItemService;

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount()
    {
        $this->equipmentItems = VisitEquipmentItemRepository::getAll();
        $this->appointmentEquipmentItems = $this->equipmentItems->mapWithKeys(function ($item) {
            $item['equipment_item_id'] = $item->id;
            $item['amount'] = 0;
            return [$item->id => $item];
        })->toArray() ?? [];

    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('show-add-equipment-modal')]
    public function initModal(VisitAppointment $appointment)
    {
        $this->appointment = $appointment;

        foreach ($this->appointment->equipmentItems as $key => $appointmentItem) {
            $this->appointmentEquipmentItems[$appointmentItem->id]['equipment_item_id'] = $appointmentItem->id;
            $this->appointmentEquipmentItems[$appointmentItem->id]['amount'] = $appointmentItem->pivot->amount ?? 0;
        }
    } // initModal()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('visitor-management::livewire.visit-logistic-queue.modals.edit-equipment-items');

    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function resetModal()
    {
        //
    } // resetModal()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function saveEquipment()
    {
        try {
            $this->appointmentEquipmentItemService->saveOrDeleteMultiple($this->appointmentEquipmentItems, $this->appointment->id);
            $this->logService->log(LogLevel::Info, "Appointment {$this->appointment->subject} equipment items edited by " . auth()->user()->name . ' (' . auth()->user()->email . ')');
            $this->banner(__('visitor-management::visit-appointments.appointment_saved_successfully', [
                'subject' => $this->appointment->subject
            ]));

            $this->dispatch('equipment-saved');
            $this->dispatch('logistic-queue-edited');
        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'Appointments/Modals/saveEquipmentItems error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when editing equipment items. Check the logs for more information.');
        }
    } // saveEquipment()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class EditEquipmentItems extends Component {}
