<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-03-25 09:32:38
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitOpeningHours;


use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Models\VisitOpeningHourException;
use BplanModules\VisitorManagement\Repositories\VisitTypeRepository;
use BplanModules\VisitorManagement\Services\VisitOpeningHourExceptionService;
use Illuminate\Database\Eloquent\Collection;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.1.0 / 2025-03-27
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
class Index extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */
    protected VisitOpeningHourExceptionService $openingHourExceptionService;
    protected LogService $logService;

    public ?Collection $openingHoursExceptions;
    public ?Collection $visitTypes;
    public array $openingHours = [];
    public array $_weekdays = [
        'Sunday',
        'Monday',
        'Tuesday',
        'Wednesday',
        'Thursday',
        'Friday',
        'Saturday',
    ];

    protected $listeners = [
        'opening-hours-edited' => 'render',
        'opening-hours-exceptions-edited' => 'render'
    ];

/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    public function mount()
    {
        //
    }

    public function boot(VisitOpeningHourExceptionService $openingHourExceptionService, LogService $logService)
    {
        $this->openingHourExceptionService = $openingHourExceptionService;
        $this->logService = $logService;
    }

    public function delete(int $id)
    {
        try {
            $this->openingHourExceptionService->delete($id);
            $this->dispatch('opening-hours-exceptions-edited');

        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'OpeningHours/Modals/Index delete error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when deleting opening hours exception. Check the logs for more information.');
        }
    }

    private function _getOpeningHours()
    {
        $this->visitTypes = VisitTypeRepository::getAll();
        $this->openingHoursExceptions = VisitOpeningHourException::all();
// dd($this->visitTypes);
        foreach ($this->visitTypes as $visitTypeIndex => $visitType) {
            $visitTypeOpeningHours = $visitType->openingHours;
// dd($visitType->openingHours);
if (!empty($visitTypeOpeningHours)) {
            foreach ($visitTypeOpeningHours as $key => $visitTypeOpeningHour) {
                $this->openingHours[$visitType->identifier][$visitTypeOpeningHour->weekday]['open'] = $visitTypeOpeningHour->open;
                $this->openingHours[$visitType->identifier][$visitTypeOpeningHour->weekday]['begin'] = $visitTypeOpeningHour->begin;
                $this->openingHours[$visitType->identifier][$visitTypeOpeningHour->weekday]['end'] = $visitTypeOpeningHour->end;
                $this->openingHours[$visitType->identifier][$visitTypeOpeningHour->weekday]['weekday'] = $visitTypeOpeningHour->weekday;
            }
}

if ($this->openingHours === null) {
    $this->openingHours = [];
}
// dd($visitType->openingHours);
        }
    }

    /**
     *
     * @version     1.0.0 / 2025-03-25
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function render()
    {
        $this->_getOpeningHours();

        return view('visitor-management::livewire.visit-opening-hours.index');

    } // render()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Index extends Component {}
