<?php

namespace BplanModules\VisitorManagement\Livewire\VisitOpeningHours\Modals;

use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Repositories\VisitTypeRepository;
use BplanModules\VisitorManagement\Services\VisitOpeningHourExceptionService;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Attributes\Validate;
use Livewire\Component;


class AddException extends Component
{
    use InteractsWithBanner;

    protected VisitOpeningHourExceptionService $openingHourExceptionService;
    protected LogService $logService;

    public ?Collection $visitTypes;
    #[Validate('exists:visit_types,id')]
    public ?string $visitTypeId;
    public bool $isOpen = true;
    #[Validate('required')]
    public ?string $date;
    #[Validate('required')]
    public ?string $startTime;
    #[Validate('required')]
    public ?string $endTime;

    public function mount()
    {
        $this->date = Carbon::now()->toDateString();
        $this->startTime = Carbon::now()->toTimeString();
        $this->endTime = Carbon::now()->endOfDay()->toTimeString();
    }

    public function boot(VisitOpeningHourExceptionService $openingHourExceptionService, LogService $logService)
    {
        $this->openingHourExceptionService = $openingHourExceptionService;
        $this->logService = $logService;

        $this->visitTypes = VisitTypeRepository::getAll();
    }

    public function render()
    {
        return view('visitor-management::livewire.visit-opening-hours.modals.add-exception');
    }

    public function save()
    {
        $this->validate();

        try
        {
            $this->openingHourExceptionService->create([
                'visit_type_id' => $this->visitTypeId,
                'open' => $this->isOpen,
                'date' => $this->date,
                'begin' => $this->startTime,
                'end' => $this->endTime,
            ]);

            $this->dispatch('opening-hours-exceptions-edited');
        }
        catch (\Throwable $th)
        {
            $this->logService->log(LogLevel::Error, 'OpeningHours/Modals/AddException save error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when adding opening hours exception. Check the logs for more information.');
        }
    }

    public function resetModal()
    {
        $this->resetExcept('openingHoursService', 'visitTypes');

        $this->date = Carbon::now()->toDateString();
        $this->startTime = Carbon::now()->toTimeString();
        $this->endTime = Carbon::now()->endOfDay()->toTimeString();
    }
}
