<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:42
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitVisitors;


use BplanModules\VisitorManagement\Models\VisitVisitor;
use Livewire\Attributes\Url;
use Livewire\Component;
use Livewire\WithPagination;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Index extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use WithPagination;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @var boolean
     */
    #[Url(keep: false)]
    public $filterHideAnonymizedUsers = true;


    /**
     *
     * @var boolean
     */
    #[Url(keep: false)]
    public $filterShowVerifiedUsersOnly = true;


    /**
     *
     * @var array
     */
    #[Url(keep: false)]
    public $filterVisitors = [];


    /**
     *
     * @var array
     */
    protected $listeners = [
        'visitor-created' => 'render',
        'visitor-edited' => 'render',
        'visitor-deleted' => 'render',
    ];


    /**
     *
     * @var string
     */
    public string $search = '';


    /**
     *
     * @var integer
     */
    public $visitorsCount = 0;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function getVisitors()
    {
        $visitors = VisitVisitor::query();
        $search = $this->search;

        if (!empty($search)) {
            $visitors->where('first_name', 'like', "%$search%")
            ->orWhere('email', 'like', "%$search%")
            ->orWhere('last_name', 'like', "%$search%");
        }
        if ($this->filterShowVerifiedUsersOnly == true) {
            $visitors->where('verified', true);
        }
        if ($this->filterHideAnonymizedUsers == true) {
            $visitors->where('anonymized', false);
        }
        return $visitors->paginate(12);

    } // getVisitors()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('visitor-management::livewire.visit-visitors.index', [
            'visitors' => $this->getVisitors(),
        ]);
    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updated($name, $value)
    {
        switch ($name) {
            case 'filterShowVerifiedUsersOnly':
            case 'filterHideAnonymizedUsers':
            case 'search':
                $this->resetPage();
                break;

            default:
                # code...
                break;
        }
    } // updated()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Index extends Component {}
