<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:42
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitVisitors\Personalize;


use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Enums\AttachmentFileType;
use BplanModules\VisitorManagement\Enums\ImportContext;
use BplanModules\VisitorManagement\Enums\ProcessStatus;
use BplanModules\VisitorManagement\Imports\GroupVisitorsImport;
use BplanModules\VisitorManagement\Models\VisitAppointment;
use BplanModules\VisitorManagement\Models\VisitVisitor;
use BplanModules\VisitorManagement\Repositories\VisitAppointmentRepository;
use BplanModules\VisitorManagement\Services\VisitAppointmentService;
use BplanModules\VisitorManagement\Services\VisitVisitorService;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Attributes\On;
use Livewire\Attributes\Url;
use Livewire\Attributes\Validate;
use Livewire\Component;
use Livewire\WithFileUploads;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Index extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use WithFileUploads;
    use InteractsWithBanner;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @var string|null
     */
    #[Url(keep: true)]
    public ?string $token;


    /**
     *
     * @var string|null
     */
    #[Validate('required')]
    public ?string $firstname;


    /**
     *
     * @var string|null
     */
    #[Validate('required')]
    public ?string $lastname;


    /**
     *
     * @var string|null
     */
    #[Validate('required|email:rfc,dns')]
    public ?string $email;


    /**
     *
     * @var string|null
     */
    #[Validate('required|phone:INTERNATIONAL')]
    public ?string $mobilenumber;


    // #[Validate('required')]
    // public ?string $birthday;
    // #[Validate('required')]
    // public ?string $country;
    // #[Validate('required')]
    // public ?string $postcode;
    // #[Validate('required')]
    // public ?string $street;
    // #[Validate('required')]
    // public ?string $housenumber;


    /**
     *
     * @var [type]
     */
    #[Validate('nullable|mimes:csv,xls,xlsx')]
    public $additionalVisitorsFile;


    /**
     *
     * @var boolean
     */
    public bool $isAdditionalVisitorsFileUploaded = false;


    /**
     *
     * @var boolean
     */
    #[Validate('required|accepted')]
    public bool $safetyBriefing = false;


    /**
     *
     * @var VisitVisitor|null
     */
    public ?VisitVisitor $visitor;


    /**
     *
     * @var VisitAppointment|null
     */
    public ?VisitAppointment $appointment;


    /**
     *
     * @var array|null
     */
    public ?array $additionalVisitors;


    /**
     *
     * @var array|null
     */
    public ?array $additionalVisitorsAttributes;


    /**
     *
     * @var string|null
     */
    public ?string $licensePlate = "";


    /**
     *
     */
    // public ?array $appointmentVehicles;


    /**
     *
     * @var string|null
     */
    public ?string $importSuccessMessage;


    /**
     *
     * @var LogService
     */
    protected LogService $logService;


    /**
     *
     * @var VisitVisitorService
     */
    protected VisitVisitorService $visitorService;


    /**
     *
     * @var VisitAppointmentService
     */
    protected VisitAppointmentService $appointmentService;


    /**
     *
     * @var array
     */
    protected $listeners = [
        'visitor-created' => 'render',
        'visitor-edited' => 'render',
        'visitor-deleted' => 'render',
    ];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(
        LogService $logService,
        VisitVisitorService $visitorService,
        VisitAppointmentService $appointmentService,
    )
    {
        $this->logService = $logService;
        $this->visitorService = $visitorService;
        $this->appointmentService = $appointmentService;

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function initVisitor()
    {
        $this->firstname = $this->visitor->first_name;
        $this->lastname = $this->visitor->last_name;
        $this->email = $this->visitor->email;
        $this->mobilenumber = $this->visitor->mobile_phone_number;
        $this->safetyBriefing = $this->visitor->safety_briefing_confirmed ? true : false;
        $this->licensePlate = $this->appointment->license_plate_formatted;
        // $this->birthday = $visitor->birthday;
        // $this->country = $visitor->country;
        // $this->postcode = $visitor->zip;
        // $this->street = $visitor->street;
        // $this->housenumber = $visitor->housenumber;

        $this->dispatch('init-tippyjs');

    } // initVisitor()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function importNow()
    {
        try {
            if(isset($this->additionalVisitorsFile))
            {
                $this->logService->log(LogLevel::Info, "Starting direct-import.");
                $import = new GroupVisitorsImport(ImportContext::Upload);
                $import->setAppointmentID($this->appointment->id);
                $import->importFile($this->additionalVisitorsFile->getRealPath());
                $this->logService->log(LogLevel::Info, "Direct-Import finished.");

                $this->importSuccessMessage = trans('visitor-management::personalization.visitors_imported_successfully', ['count' => $import->getRowCountSaved()]);
            }
        } catch (\Throwable $th) {
            $this->addError('additionalVisitorsFile', trans('visitor-management::personalization.error_while_importing') . $th->getMessage());
        }
    } // importNow()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount()
    {
        try {
            $token = $this->token ?? null;
            $this->appointment = VisitAppointment::where('web_token', $token)->where('process_status', '<', ProcessStatus::Finished)->firstOrFail(); //VisitAppointmentRepository::getModelByToken($token);

        } catch (\Throwable $th) {
            return abort(404, 'Appointment not found');
        }

        if (isset($token) && isset($this->appointment)) {
            $this->visitor = VisitVisitor::findOrFail($this->appointment->main_visitor_id);

            if(isset($this->appointment) ) // && $this->appointment->drive_on_area_permitted === true
            {
                $this->additionalVisitors = (array)$this->appointment->visitors;
                // $this->appointmentVehicles = $this->appointment->vehicles->map(function ($vehicle) {
                //     $vehicleArray = $vehicle->getAttributes();

                //     return $vehicleArray;
                // })->toArray();
            } else {
                echo 'Appointment not found, please check your token.';
                exit;
            }

            $this->initVisitor();
        } else {
            // return response("Visitor or token invalid", 404);
            return abort(404, 'Visitor not found');
        }
    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('visitor-added')]
    public function onVisitorAdded(?array $visitor)
    {
        $this->additionalVisitors[] = (object) $visitor;
        $this->additionalVisitorsAttributes[array_key_last($this->additionalVisitors)]['__added'] = true;

    } // onVisitorAdded()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('visitor-deleted')]
    public function onVisitorDeleted(int $index)
    {
        if(isset($index))
        {
            unset($this->additionalVisitors[$index]);
        }
    } // onVisitorDeleted()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('visitor-edited')]
    public function onVisitorEdited(?int $index, ?array $visitor)
    {
        if(isset($index) && isset($visitor))
        {
            $this->additionalVisitors[$index] = (object) $visitor;
            if(!isset($this->additionalVisitorsAttributes[$index]['__added']))
            {
                $this->additionalVisitorsAttributes[$index]['__edited'] = true;
            }
        }
    } // onVisitorEdited()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function personalizeAppointment()
    {

        if($this->appointment->drive_on_area_permitted === true)
        {
            $data = [
                'licensePlate' => $this->licensePlate,
            ];

            $validator = Validator::make($data, [
                "licensePlate" => 'required',
            ])->validate();
        }

        try {
            $this->visitorService->update($this->visitor, [
                'first_name' => $this->firstname,
                'last_name' => $this->lastname,
                'email' => $this->email,
                'mobile_phone_number' => $this->mobilenumber,
                'safety_briefing_confirmed' => now(),
                // 'birthday' => $this->birthday,
                // 'country' => $this->country,
                // 'zip' => $this->postcode,
                // 'street' => $this->street,
                // 'housenumber' => $this->housenumber,
                // 'hasSafetyBriefing' => $this->hasSafetyBriefing,
            ]);
            $this->logService->log(LogLevel::Info, "Visitor {$this->firstname}, {$this->lastname} has persoanlized his data.");

            // Änderungen des Besuchers in DB übernehmen
            // foreach ($this->additionalVisitors as $key => $additionalVisitor) {
            //     if (isset($additionalVisitor['id'])) {
            //         $this->visitorService->update($additionalVisitor['id'], [
            //             'first_name' => $additionalVisitor['frist_name'],
            //             'last_name' => $additionalVisitor['frist_name'],
            //             'email' => $additionalVisitor['email'],
            //             'mobile_phone_number' => $additionalVisitor['mobile_phone_number'],
            //             'company' => $additionalVisitor['company'],
            //         ]);
            //     }
            // }

            $this->appointmentService->update($this->appointment->id, [
                'visitors' => $this->additionalVisitors,
                'license_plate_formatted' => $this->licensePlate,
            ]);

            $this->logService->log(LogLevel::Info, "Appointment {$this->appointment->subject} with ID {$this->appointment->id} has been updated in the personalization.");


            try {
                if(isset($this->additionalVisitorsFile))
                {
                    $this->logService->log(LogLevel::Info, "Starting import.");
                    // $import = new EmployeesImport(ImportContext::Upload);
                    // $import->importFile($this->additionalVisitorsFile->getRealPath());
                    $import = new GroupVisitorsImport(ImportContext::Upload);
                    $import->setAppointmentID($this->appointment->id);
                    $import->importFile($this->additionalVisitorsFile->getRealPath());
                    $this->logService->log(LogLevel::Info, "Import finished.");
                } else {
                    $this->logService->log(LogLevel::Info, "Not importing because no import file is given.");
                }
            } catch (\Throwable $th) {
                $this->logService->log(LogLevel::Error, 'Visitors/Personalize/Index error importing: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
                $this->dangerBanner('Error when importing visitors. Check the logs for more information.');
            }

            $this->dispatch('init-tippyjs');
            $this->dispatch('appointment-personalized');

        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'Visitors/Personalize/Index error editVisitor: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when editing visitor. Check the logs for more information.');
        }
    } // personalizeAppointment()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function removeVisitor(int $index)
    {
        if(isset($index))
        {
            unset($this->additionalVisitors[$index]);
        }
    } // removeVisitor()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        $this->dispatch('init-tippyjs');

        $filename = basename(VisitAppointmentRepository::determineAttachmentFile($this->appointment->id, AttachmentFileType::SafetyBriefing));
        $safetyBriefingUrl = Storage::disk('public')->url($filename);

        return view('visitor-management::livewire.visit-visitors.personalize.index', [
            'safetyBriefingUrl' => $safetyBriefingUrl,
        ]);
    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updated($property, $value)
    {
        // $property: The name of the current property being updated
        // $value: The value about to be set to the property

        switch ($property) {
            case 'additionalVisitorsFile':
                if(isset($this->additionalVisitorsFile))
                {
                    $this->isAdditionalVisitorsFileUploaded = true;
                }
                break;

            default:
                //
                break;
        }
    } // updated()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Index extends Component {}
