<?php

namespace BplanModules\VisitorManagement\Livewire\VisitVisitors\Personalize\Modals;

use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Models\VisitVisitor;
use BplanModules\VisitorManagement\Services\VisitVisitorService;
use Exception;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Attributes\On;
use Livewire\Attributes\Validate;
use Livewire\Component;
use stdClass;

class Edit extends Component
{
    use InteractsWithBanner;

    #[Validate('required')]
    public ?string $firstname;
    #[Validate('required')]
    public ?string $lastname;
    #[Validate('required|email:rfc,dns')]
    public ?string $email;
    #[Validate('required')]
    public ?string $mobilenumber;
    #[Validate('required|accepted')]
    public ?bool $isMobilenumberValid = true; // Ausgehend davon, dass man nur mit einer gültigen nummer Speichern kann
    #[Validate('required')]
    public ?string $company;
    // #[Validate('required')]
    // public ?string $birthday;
    // #[Validate('required')]
    // public ?string $country;
    // #[Validate('required')]
    // public ?string $postcode;
    // #[Validate('required')]
    // public ?string $street;
    // #[Validate('required')]
    // public ?string $housenumber;

    public ?array $visitor;
    public ?int $index;

    protected LogService $logService;
    protected VisitVisitorService $visitorService;

    public function boot(LogService $logService, VisitVisitorService $visitorService)
    {
        $this->logService = $logService;
        $this->visitorService = $visitorService;
    }

    public function render()
    {
        return view('visitor-management::livewire.visit-visitors.personalize.modals.edit');
    }

    #[On('show-edit-added-visitor-modal')]
    public function initAddedVisitor(int $index, array $visitor)
    {
        // Benutzer die neu hinzugefügt worden sind
        $this->initVisitor($index, $visitor);
    }

    #[On('show-edit-visitor-modal')]
    public function initVisitor(int $index, array $visitor)
    {
        // Benutzer die bereits hinzugefügt worden
        $this->index = $index;
        $this->visitor = $visitor;

        if(is_array($visitor))
        {
            $this->firstname = $visitor['first_name'];
            $this->lastname = $visitor['last_name'];
            $this->email = $visitor['email'];
            $this->mobilenumber = $visitor['mobile_phone_number'];
            $this->isMobilenumberValid = true;
            $this->company = $visitor['company'];
        }
        // $this->birthday = $visitor->birthday;
        // $this->country = $visitor->country;
        // $this->postcode = $visitor->zip;
        // $this->street = $visitor->street;
        // $this->housenumber = $visitor->housenumber;
        // $this->hasSafetyBriefing = $visitor->hasSafetyBriefing;
    }

    public function resetModal()
    {
        $this->visitor = null;

        $this->firstname = null;
        $this->lastname = null;
        $this->email = null;
        $this->mobilenumber = null;
        $this->company = null;
        // $this->birthday = null;
        // $this->country = null;
        // $this->postcode = null;
        // $this->street = null;
        // $this->housenumber = null;
        // $this->hasSafetyBriefing = null;
    }

    public function editVisitor()
    {
        $this->validate();

        try {
            if(isset($this->index))
            {
                $visitor = [
                    'first_name' => $this->firstname,
                    'last_name' => $this->lastname,
                    'email' => $this->email,
                    'mobile_phone_number' => $this->mobilenumber,
                    'company' => $this->company,
                ];
            }


            $this->logService->log(LogLevel::Info, "Visitor {$this->firstname}, {$this->lastname} edited in personalization screen.");

            $this->dispatch('init-tippyjs');
            $this->dispatch('visitor-edited', index: $this->index, visitor: $visitor);
        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'Visitors/Personalize/Modals/editVisitor error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when editing visitor. Check the logs for more information.');
        }
    }


}
