<?php
/**
 * Message Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Messages
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Notifications\Messages;


use Illuminate\Notifications\Messages\SimpleMessage;


/**
 * Message Class
 *
 * @version     1.0.0 / 2024-11-30
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class PHPMailerMessage
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @var     string $_altBody
     */
    protected $_altBody;


    /**
     *
     * @var     array $_attachments
     */
    protected $_attachments = [];


    /**
     *
     * @var     array $_bccRecipients
     */
    protected $_bccRecipients = [];


    /**
     *
     * @var     string $_body
     */
    protected $_body;


    /**
     *
     * @var     array $_ccRecipients
     */
    protected $_ccRecipients = [];


    /**
     *
     * @var     array $_from
     */
    public $_from;


    /**
     *
     * @var     string $_iCal
     */
    public $_iCal;


    /**
     *
     * @var     array $_recipients
     */
    protected $_recipients = [];


    /**
     *
     * @var     array $_replyTo
     */
    protected $_replyTo = [];


    /**
     * The subject of the notification.
     *
     * @var     string $_subject
     */
    protected $_subject;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $file
     *
     * @param       null|string $name
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function addAttachment(string $file, null|string $name = null): self
    {
        $this->_attachments[] = [
            'file' => $file,
            'name' => $name,
        ];
        return $this;

    } // addAttachment()


    /**
     *
     * @param       string $email
     *
     * @param       null|string $name
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function addBccRecipient(string $email, null|string $name = null): self
    {
        $this->_bccRecipients[] = [
            'email' => $email,
            'name' => $name ?? $email,
        ];
        return $this;

    } // addBccRecipient()


    /**
     *
     * @param       string $email
     *
     * @param       null|string $name
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function addCcRecipient(string $email, null|string $name = null): self
    {
        $this->_ccRecipients[] = [
            'email' => $email,
            'name' => $name ?? $email,
        ];
        return $this;

    } // addCcRecipient()


    /**
     *
     * @param       string $email
     *
     * @param       null|string $name
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function addRecipient(string $email, null|string $name = null): self
    {
        $this->_recipients[] = [
            'email' => $email,
            'name' => $name ?? $email,
        ];
        return $this;

    } // addRecipient()


    /**
     *
     * @param       string $email
     *
     * @param       null|string $name
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function addReplyTo(string $email, null|string $name = null): self
    {
        $this->_replyTo[] = [
            'email' => $email,
            'name' => $name ?? $email,
        ];
        return $this;

    } // addReplyTo()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getAltBody(): string
    {
        if (empty($this->_altBody)) {
            if (empty($this->_body)) {
                return "\n";
            } else {
                return strip_tags($this->_body);
            }
        }
        return $this->_altBody;

    } // getAltBody()


    /**
     *
     * @return 	    array
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getAttachments(): array
    {
        return $this->_attachments;

    } // getAttachments()


    /**
     *
     * @return 	    array
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getBccRecipients(): array
    {
        return $this->_bccRecipients;

    } // getBccRecipients()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getBody(): string
    {
        if (empty($this->_body)) {
            return '<br>';
        }
        return $this->_body;

    } // getBody()


    /**
     *
     * @return 	    array
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getCcRecipients(): array
    {
        return $this->_ccRecipients;

    } // getCcRecipients()


    /**
     *
     * @return 	    array|null
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getFrom(): array|null
    {
        return $this->_from;

    } // getFrom()


    /**
     *
     * @return 	    null|string
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getIcal(): null|string
    {
        return $this->_iCal;

    } // getIcal()


    /**
     *
     * @return 	    array
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getRecipients(): array
    {
        return $this->_recipients;

    } // getRecipients()


    /**
     *
     * @return 	    array
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getReplyTo(): array
    {
        return $this->_replyTo;

    } // getReplyTo()


    /**
     *
     * @return 	    null|string
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getSubject(): null|string
    {
        return $this->_subject;

    } // getSubject()


    /**
     *
     * @param       string $altBody
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setAltBody(string $altBody): self
    {
        $this->_altBody = $altBody;

        return $this;

    } // getAltBody()


    /**
     *
     * @param       string $body
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setBody(string $body): self
    {
        $this->_body = $body;

        return $this;

    } // setBody()


    /**
     *
     * @param       string $email
     *
     * @param       null|string $name
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setFrom($email, $name = null): self
    {
        $this->_from = [
            'email' => $email,
            'name' => $name ?? $email,
        ];
        return $this;

    } // setFrom()


    /**
     *
     * @param       string $iCal
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setIcal(string $iCal): self
    {
        $this->_iCal = $iCal;

        return $this;

    } // setIcal()


    /**
     *
     * @param       string $subject
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setSubject(string $subject): self
    {
        $this->_subject = $subject;

        return $this;

    } // setSubject()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class PHPMailerMessage {}
