<?php
/**
 * Package Service Provider Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Providers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement;

use BplanBase\Globals\Registries\SeederRegistry;
use BplanBase\Globals\Support\LivewireComponentAutoDiscovery;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;


/**
 * Package Service Provider Class
 *
 * @version     1.1.0 / 2025-05-03
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class PackageServiceProvider extends ServiceProvider
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var         string $_basePath
     */
    protected string $_basePath;


    /**
     * @var         string $_baseNamespace
     */
    protected string $_baseNamespace = 'BplanModules\\VisitorManagement';


    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var         bool $defer
     */
    protected bool $defer = false;


    /**
     * @var         int $_packageKey
     */
    protected int $_packageKey = 1501;


    /**
     * @var         string $_packageName
     */
    protected string $_packageName = 'visitor-management';


    /**
     * @var         string $_vendorPackageName
     */
    protected string $_vendorPackageName = 'bplan-modules/visitor-management';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Bootstrap the application events.
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(): void
    {
        /*
        **  Inform Laravel about translations. */
        $this->loadTranslationsFrom($this->_basePath.'/lang', $this->_packageName);

        if ($this->app->runningInConsole()) {
            /*
            **  Inform Laravel about migrations. */
            $this->loadMigrationsFrom($this->_basePath.'/database/migrations');
        }
        /*
        **  Inform Laravel about views. */
        $this->loadViewsFrom($this->_basePath.'/resources/views', $this->_packageName);
        /*
        **  Define a namespace for Blade components. */
        Blade::componentNamespace('BplanModules\\VisitorManagement\\View\\Components', $this->_packageName);

        LivewireComponentAutoDiscovery::register($this->_baseNamespace.'\\Livewire', $this->_basePath.'/src/Livewire', $this->_packageName);
        /*
        **  Load package routes. */
        $this->loadRoutesFrom($this->_basePath.'/routes/api.php');
        $this->loadRoutesFrom($this->_basePath.'/routes/web.php');

    } // boot()


    /**
     * Register the service provider.
     *
     * @return      void
     *
     * @version     1.1.0 / 2025-05-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function register(): void
    {
        $this->_basePath = str_replace('\\', '/', realpath(__DIR__.'/..'));
        /*
        **  Load the package configuration. */
        $this->mergeConfigFrom($this->_basePath.'/config/'.$this->_packageName.'.php', $this->_packageName);

        if ($this->app->runningInConsole()) {
            SeederRegistry::register($this->_packageKey, $this->_vendorPackageName, \BplanModules\VisitorManagement\Database\Seeders\DatabaseSeeder::class);
            SeederRegistry::register($this->_packageKey + 2000, $this->_vendorPackageName, \BplanModules\VisitorManagement\Database\Seeders\PostDatabaseSeeder::class);
        }
    } // register()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class PackageServiceProvider extends ServiceProvider {}
