<?php
/**
 * Repository Class
 *
 * Wegen individueller Anpassungen aus der automatischen Generierung genommen.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:42
 * @package     bplan-modules/visitor-management
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Repositories;


use BplanModules\VisitorManagement\Models\VisitAppointmentEmployee;
use Illuminate\Database\Eloquent\Collection;


/**
 * Repository Class
 *
 * @version     3.1.0 / 2025-04-21
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitAppointmentEmployeeRepository
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected static $_modelClass = \BplanModules\VisitorManagement\Models\VisitAppointmentEmployee::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Ermittelt die ID zu den übergebenen Employee-Daten
     *
     * @param       int|string $employeeId
     *
     * @param       bool $ignoreCache
     *              Steuert die Verwendung des Methoden-Cache beim Ermitteln des Ergebnisses.
     *              Wenn TRUE übergeben wird, dann wird ein Datenbankzugriff durchgeführt, auch wenn
     *              der Methoden-Cache bereits einen passenden Eintrag enthält.
     *              Die Speicherung eines Wertes im Methoden-Cache wird von diesem Parameter nicht
     *              beeinflusst.
     *
     * @return      int|null
     *
     * @version     1.1.0 / 2024-11-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function findAppointments(int|string $employeeId, bool $ignoreCache = false): int|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            if ($cache[$cacheKey] === false) {
                return null;
            }
            return $cache[$cacheKey];
        }
        $appointments = static::$_modelClass::where('employee_id', '=', $employeeId)
            ->get()
            ->toArray();

        if ($appointments === null) {
            $cache[$cacheKey] = false;

            return null;
        }
        return $cache[$cacheKey] = $appointments[0]['id'];

    } // findAppointments()


    /**
     * Returns a collection of models
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the
     *              method cache already contains a suitable entry. The storage of
     *              a value in the method cache is not affected by this parameter.
     *
     * @param       array|string|null $orderBy
     *              @see BplanBase\Globals\Helpers\QueryHelper::applyOrderBy() for
     *              details.
     *
     * @param       bool $withInactive
     *              By default, only the active data records are returned. By
     *              setting this parameter to TRUE, the inactive data records can
     *              also be read out.
     *
     * @return      Collection
     *
     * @version     2.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getAll(bool $ignoreCache = false, array|string|null $orderBy = null): Collection
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::query()
            ->ordered($orderBy);

        return $cache[$cacheKey] = $Query->get();

    } // getAll()


    /**
     * Returns the model instance for the given ID
     *
     * @param       int|string $id
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      VisitAppointmentEmployee|DerivedVisitAppointmentEmployee
     *
     * @version     2.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getById(int|string $id, bool $ignoreCache = false, bool $returnOrFail = true): VisitAppointmentEmployee|DerivedVisitAppointmentEmployee|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::query();

        if ($returnOrFail === true) {
            return $Query->find($id);
        }
        return $Query->findOrFail($id);

    } // getById()


    /**
     * Überprüft ob ein Employee bereits mit einem bestimmten Appointment verknüpft ist
     *
     * @param       int|string $appointmentId
     *
     * @param       int|string $employeeId
     *
     * @param       bool $ignoreCache
     *              Steuert die Verwendung des Methoden-Cache beim Ermitteln des Ergebnisses.
     *              Wenn TRUE übergeben wird, dann wird ein Datenbankzugriff durchgeführt, auch wenn
     *              der Methoden-Cache bereits einen passenden Eintrag enthält.
     *              Die Speicherung eines Wertes im Methoden-Cache wird von diesem Parameter nicht
     *              beeinflusst.
     *
     * @return      int|bool
     *              Liefert die ID der Verknüpfung oder FALSE, wenn keine Verknüpfung gefunden
     *              werden konnte.
     *
     * @version     1.1.0 / 2024-11-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function isLinked(int|string $appointmentId, int|string $employeeId, bool $ignoreCache = false): bool|int
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $AppointmentEmployee = static::$_modelClass::select('id')
            ->where('appointment_id', '=', $appointmentId)
            ->where('employee_id', '=', $employeeId)
            ->first();

        if ($AppointmentEmployee === null) {
            return $cache[$cacheKey] = false;
        }
        return $cache[$cacheKey] = $AppointmentEmployee->id;

    } // isLinked()


} // class VisitAppointmentEmployeeRepository {}
