<?php
/**
 * Repository Class
 *
 * Wegen individueller Anpassungen aus der automatischen Generierung genommen.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:42
 * @package     bplan-modules/visitor-management
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Repositories;


use App\Models\VisitAppointmentEquipmentItem as DerivedVisitAppointmentEquipmentItem;
use BplanModules\VisitorManagement\Models\VisitAppointment;
use BplanModules\VisitorManagement\Models\VisitAppointmentEquipmentItem;
use Illuminate\Database\Eloquent\Collection;


/**
 * Repository Class
 *
 * @version     2.1.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitAppointmentEquipmentItemRepository
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected static $_modelClass = \BplanModules\VisitorManagement\Models\VisitAppointmentEquipmentItem::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Returns a collection of models
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the
     *              method cache already contains a suitable entry. The storage of
     *              a value in the method cache is not affected by this parameter.
     *
     * @param       array|string|null $orderBy
     *              @see BplanBase\Globals\Helpers\QueryHelper::applyOrderBy() for
     *              details.
     *
     * @param       bool $withInactive
     *              By default, only the active data records are returned. By
     *              setting this parameter to TRUE, the inactive data records can
     *              also be read out.
     *
     * @return      Collection
     *
     * @version     2.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getAll(bool $ignoreCache = false, array|string|null $orderBy = null): Collection
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::query()
            ->ordered($orderBy);

        return $cache[$cacheKey] = $Query->get();

    } // getAll()


    /**
     * Returns the model instance for the given ID
     *
     * @param       int|string $id
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      VisitAppointmentEquipmentItem|DerivedVisitAppointmentEquipmentItem|null
     *
     * @version     2.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getById(int|string $id, bool $ignoreCache = false, bool $returnOrFail = true): VisitAppointmentEquipmentItem|DerivedVisitAppointmentEquipmentItem|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::query();

        if ($returnOrFail === true) {
            return $cache[$cacheKey] = $Query->find($id);
        }
        return $cache[$cacheKey] = $Query->findOrFail($id);

    } // getById()


    /**
     *
     * @param       int|string|VisitAppointment $appointment
     *
     * @return      Collection
     *
     * @version     1.0.0 / 2024-12-11
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getByAppointment(int|string|VisitAppointment $appointment): Collection
    {
        if ($appointment instanceof VisitAppointment) {
            $appointmentId = $appointment->id;
        } else {
            $appointmentId = $appointment;
        }
        return static::$_modelClass::where('appointment_id', '=', $appointmentId)
            ->get();

    } // getByAppointment()


    /**
     * Überprüft ob ein EquipmentItem bereits mit einem bestimmten Appointment verknüpft ist
     *
     * @param       int|string $appointment_id
     *
     * @param       int|string $equipment_item_id
     *
     * @param       bool $ignoreCache
     *              Steuert die Verwendung des Methoden-Cache beim Ermitteln des Ergebnisses.
     *              Wenn TRUE übergeben wird, dann wird ein Datenbankzugriff durchgeführt, auch wenn
     *              der Methoden-Cache bereits einen passenden Eintrag enthält.
     *              Die Speicherung eines Wertes im Methoden-Cache wird von diesem Parameter nicht
     *              beeinflusst.
     *
     * @return      int|bool
     *              Liefert die ID der Verknüpfung oder FALSE, wenn keine Verknüpfung gefunden
     *              werden konnte.
     *
     * @version     1.1.0 / 2024-11-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function isLinked(int|string $appointment_id, int|string $equipment_item_id, bool $ignoreCache = false): bool|int
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $AppointmentEquipmentItem = static::$_modelClass::select('id')
            ->where('appointment_id', '=', $appointment_id)
            ->where('equipment_item_id', '=', $equipment_item_id)
            ->first();

        if ($AppointmentEquipmentItem === null) {
            return $cache[$cacheKey] = false;
        }
        return $cache[$cacheKey] = $AppointmentEquipmentItem->id;

    } // isLinked()


} // class VisitAppointmentEquipmentItemRepository {}
