<?php
/**
 * Repository Class
 *
 * Wegen individueller Anpassungen aus der automatischen Generierung genommen.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-20 12:10:51
 * @package     bplan-modules/visitor-management
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Repositories;


use App\Models\VisitEntryPoint as DerivedVisitEntryPoint;
use BplanModules\VisitorManagement\Enums\EntryPointDirection;
use BplanModules\VisitorManagement\Models\VisitEntryPoint;
use Illuminate\Database\Eloquent\Collection;


/**
 * Repository Class
 *
 * @version     2.1.0 / 2025-04-20
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitEntryPointRepository
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected static $_modelClass = \BplanModules\VisitorManagement\Models\VisitEntryPoint::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Returns a collection of models
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the
     *              method cache already contains a suitable entry. The storage of
     *              a value in the method cache is not affected by this parameter.
     *
     * @param       array|string|null $orderBy
     *              @see BplanBase\Globals\Helpers\QueryHelper::applyOrderBy() for
     *              details.
     *
     * @param       bool $withInactive
     *              By default, only the active data records are returned. By
     *              setting this parameter to TRUE, the inactive data records can
     *              also be read out.
     *
     * @return      Collection
     *
     * @version     2.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getAll(bool $ignoreCache = false, array|string|null $orderBy = null, bool $withInactive = false): Collection
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::query();

        if ($withInactive === false) {
            $Query->active();
        }
        $Query->ordered($orderBy);

        return $cache[$cacheKey] = $Query->get();

    } // getAll()


    /**
     * Returns the model instance for the given ID
     *
     * @param       int|string $id
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      VisitEntryPoint|DerivedVisitEntryPoint|null
     *
     * @version     2.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getById(int|string $id, bool $ignoreCache = false, bool $returnOrFail = true): VisitEntryPoint|DerivedVisitEntryPoint|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::query();

        if ($returnOrFail === true) {
            return $cache[$cacheKey] = $Query->find($id);
        }
        return $cache[$cacheKey] = $Query->findOrFail($id);

    } // getById()


    /**
     * Returns the model instance for the given token
     *
     * @param       string $token
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @return      VisitEntryPoint|null
     *
     * @version     2.0.0 / 2024-11-24
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getModelByToken(string $token, bool $ignoreCache = false): VisitEntryPoint|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        return $cache[$cacheKey] = static::$_modelClass::where('token', '=', $token)
            ->first();

    } // getModelByToken()


} // class VisitEntryPointRepository {}
