<?php
/**
 * Pagination Trait
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Traits
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Traits;


use BplanModules\VisitorManagement\Enums\AppointmentSteps;


/**
 * Pagination Trait
 *
 * @version     1.0.0 / 2025-04-22
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
trait AppointmentPagination
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @var         integer $appointmentStep
     */
    public int $appointmentStep;


    /**
     *
     * @var         integer $appointmentSteps
     */
    public int $appointmentSteps;


    /**
     *
     * @var         integer $firstAppointmentStep
     */
    public int $firstAppointmentStep = AppointmentSteps::General->value;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-22
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function __construct()
    {
        $this->appointmentSteps = count(AppointmentSteps::cases());
        $this->appointmentStep = auth()->user()->hasRole('Host') ? $this->firstAppointmentStep : AppointmentSteps::Overview->value; // Evtl. auf null prüfen wenn später mal in eine andere Stelle gesprungen werden soll beim öffnen

    } // __construct()


    /**
     *
     * @version     1.0.0 / 2025-04-22
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function nextStep()
    {
        $this->validate();

        if($this->appointmentStep + 1 <= $this->appointmentSteps) {
            $this->appointmentStep += 1;
        }
        $this->dispatch('appointment-pagination-updated', step: $this->appointmentStep);

    } // nextStep()


    /**
     *
     * @version     1.0.0 / 2025-04-22
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function previousStep()
    {
        if($this->appointmentStep - 1 >= $this->firstAppointmentStep) {
            $this->appointmentStep -= 1;
        }
        $this->dispatch('appointment-pagination-updated', step: $this->appointmentStep);

    } // previousStep()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // trait AppointmentPagination {}
