<?php

namespace BplanModules\VisitorManagement\View\Components\Global;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class InputRequiredHintFromDependencies extends Component
{

    public ?string $showOnSpontaneousVisit = null;
    /**
     * Create a new component instance.
     */
    public function __construct(
        public string $property,
        public bool $requiredIfSpontaneousVisit = false,
    )
    {
        if($requiredIfSpontaneousVisit)
        {
            $this->showOnSpontaneousVisit = '!isSpontaneousVisit &&';
        }
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('visitor-management::components.global.input-required-hint-from-dependencies');
    }
}
