<?php
/**
 * Visitor Management Configuration
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Config
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

return [
    'loading-bay' => [
        'email' => env('LOADING_BAY_EMAIL'),
        'sms-emergency-phone-number' => env('LOADING_BAY_SMS_EMERGENCY_PHONE_NUMBER', 'N/A'),
        'mobile-phone-number' => env('LOADING_BAY_MOBILE_PHONE_NUMBER'),
        'notification-language' => env('LOADING_BAY_NOTIFICATION_LANGUAGE'),
    ],
    'logistic-queue' => [
        'refresh_rate' => env('LOGISTIC_QUEUE_REFRESH_RATE', 30),
    ],
    'navigation' => [
        // 'access_authorization' => env('VISIT_NAVIGATION_ACCESS_AUTHORIZATION', true), // Datenbankgesteuert
        'contact-groups'       => env('VISIT_NAVIGATION_CONTACT_GROUPS',       false),
        'contact-options'      => env('VISIT_NAVIGATION_CONTACT_OPTIONS',      true),
        'countries'            => env('VISIT_NAVIGATION_COUNTRIES',            true),
        'documents'            => env('VISIT_NAVIGATION_DOCUMENTS',            true),
        'employees'            => env('VISIT_NAVIGATION_EMPLOYEES',            true),
        'equipment-items'      => env('VISIT_NAVIGATION_EQUIPMENT_ITEMS',      true),
        'locations'            => env('VISIT_NAVIGATION_LOCATIONS',            true),
        // 'logistic_queue'       => env('VISIT_NAVIGATION_LOGISTIC_QUEUE',       true), // Datenbankgesteuert
        'opening-hours'        => env('VISIT_NAVIGATION_OPENING_HOURS',        true),
        'users'                => env('VISIT_NAVIGATION_USERS',                true),
        'visitors'             => env('VISIT_NAVIGATION_VISITORS',             true),
        'visit-reasons'        => env('VISIT_NAVIGATION_VISIT_REASONS',        true),
    ],

];
