<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visit_locations');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visit_locations', function (Blueprint $Table) {
            $Table->id();
            $Table->boolean('active')->default(1);

            $Table->timestamps();
            $Table->softDeletes('deleted_at');

            $Table->string('address_addition', 255)->nullable();
            $Table->string('city', 50)->nullable();
            /*
            **  Support for spatial types depends on your database driver. Please refer to your
            **  database's documentation. If your application is utilizing a PostgreSQL database,
            **  you must install the PostGIS extension before the geometry method may be used. */
            $Table->geometry('coordinates', subtype: 'point', srid: 0)->nullable();
            $Table->string('email', 255)->nullable();
            $Table->string('house_number', 5)->nullable();
            $Table->json('labels');
            $Table->foreignId('location_type_id')->nullable()->constrained(table: 'visit_location_types', indexName: 'visit_locations_FK_location_type_id');
            $Table->foreignId('master_id')->nullable()->constrained(table: 'visit_locations', indexName: 'visit_locations_FK_master_id');
            $Table->string('phone_number', 30)->nullable();
            $Table->string('street', 50)->nullable();
            $Table->string('zip_code', 10)->nullable();

            $Table->index('location_type_id', 'visit_locations_FKI_location_type_id');
            $Table->index('master_id',        'visit_locations_FKI_master_id');

            new CodeGenerator($Table, [
                'columns' => [
                    'active' => [
                        'sortable' => true,
                    ],
                    'city' => [
                        'sortable' => true,
                    ],
                    'email' => [
                        'ruleType' => 'email',
                        'sortable' => true,
                    ],
                    'labels' => [
                        'jsonType' => CodeGenerator::JSON_TYPE_OBJECT,
                        'sortable' => true,
                    ],
                    'location_type_id' => [
                        // todo     Ohne die explizite Angabe des eines Namens würde "visit-locations"/"visitLocations" verwendet werden.
                        'reverseRelationName' => 'locations',
                    ],
                    'master_id' => [
                        // todo     Ohne die explizite Angabe des eines Namens würde "visit-locations"/"visitLocations" verwendet werden.
                        'reverseRelationName' => 'sub-locations',
                    ],
                    'phone_number' => [
                        'sortable' => true,
                    ],
                ],
                'traits' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\Traits\\HasActiveScope',
                        'BplanBase\\Globals\Traits\\HasOrderedScope',
                    ],
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
            ]);

        });
    } // up()

};
