<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visit_employees');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visit_employees', function (Blueprint $Table) {
            $Table->id();
            $Table->boolean('active')->default(1);

            $Table->timestamps();
            $Table->softDeletes('deleted_at');

            $Table->boolean('contact')->default(0);
            $Table->foreignId('contact_group_id')->nullable()->constrained(table: 'visit_contact_groups', indexName: 'visit_employee_FK_contact_group_id');
            $Table->string('department', 50)->nullable();
            $Table->string('email', 255)->nullable();
            $Table->boolean('emergency_contact')->default(0);
            $Table->string('first_name', 50);
            $Table->string('function', 50)->nullable();
            $Table->boolean('global_contact')->default(0);
            $Table->unsignedInteger('import_failure_count')->default(0)->comment('Anzahl der Fehler beim letzten Import.');
            $Table->json('import_failures')->nullable()->comment('Liste der Fehler des letzten Imports.');
            $Table->string('last_name', 50);
            $Table->string('license_plate', 255)->nullable();
            $Table->string('mobile_phone_number', 20)->nullable();
            $Table->string('mobile_phone_number_country_code', 4)->nullable();
            $Table->string('personnel_number', 10);
            $Table->string('phone_number', 20)->nullable();
            $Table->string('phone_number_country_code', 4)->nullable();
            $Table->foreignId('user_id')->nullable()->constrained(table: 'users', indexName: 'visit_employee_FK_user_id');

            $Table->index('contact_group_id', 'employee_FKI_contact_group_id');
            $Table->index('user_id',          'employee_FKI_user_id');
            /*
            **  Damit der Employee-Import die Mail-Adresse als eindeutiges Merkmal verwenden kann,
            **  muss das Feld mit einem Unique-Key versehen werden. Das Feld kann auch Teil eines
            **  zusammengesetzten Unique-Key sein. */
            $Table->unique('email',                       'visit_employees_UKI_email');
            $Table->unique('personnel_number',            'visit_employees_UKI_personnel_number');
            $Table->unique(['email', 'personnel_number'], 'visit_employees_UKI_email_personnel_number');

            new CodeGenerator($Table, [
                'appends' => [
                    /*
                    **  Die Felder werden nur zum Schema hinzugefügt. Das Füllen der Felder geschieht in der
                    **  Methode ContactController::index(). */
                    'label' => CodeGenerator::APPENDS_JSONAPI_SCHEMA,
                    'phone' => CodeGenerator::APPENDS_JSONAPI_SCHEMA,
                ],
                'columns' => [
                    'active' => [
                        'sortable' => true,
                    ],
                    'contact' => [
                        'sortable' => true,
                    ],
                    'contact_group_id' => [
                        'reverseRelationName' => 'employees'
                    ],
                    'department' => [
                        'sortable' => true,
                    ],
                    'email' => [
                        'ruleType' => 'email',
                        'sortable' => true,
                    ],
                    'emergency_contact' => [
                        'sortable' => true,
                    ],
                    'first_name' => [
                        'sortable' => true,
                    ],
                    'function' => [
                        'sortable' => true,
                    ],
                    'global_contact' => [
                        'sortable' => true,
                    ],
                    'import_failure_count' => [
                        'sortable' => true,
                    ],
                    'import_failures' => [
                        'jsonType' => CodeGenerator::JSON_TYPE_ARRAY,
                    ],
                    'last_name' => [
                        'sortable' => true,
                    ],
                    'license_plate' => [
                        'rules' => [
                            'nullable',
                            'string',
                            'max:100',
                            //'regex:%^([A-ZÄÖÜ]{1,3}-[A-Z]{1,2}-[1-9][0-9]{0,2}[0-9EH]?)(;[A-ZÄÖÜ]{1,3}-[A-Z]{1,2}-[1-9][0-9]{0,2}[0-9EH]?)*$%',
                        ],
                    ],
                    'personnel_number' => [
                        'ruleType' => 'numeric',
                        'sortable' => true,
                    ],
                    'user_id' => [
                        'reverseRelationType' => 'hasOne',
                    ]
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
                'traits' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\Traits\\HasActiveScope',
                        'BplanBase\\Globals\Traits\\HasOrderedScope',
                        'Illuminate\Notifications\Notifiable',
                    ],
                ],
                'uses' => [
                    'laravel.model' => [
                        'Illuminate\Notifications\Notification',
                    ],
                ],
            ]);
/**/
        });

    } // up()


};
