<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visit_appointment_employee');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visit_appointment_employee', function (Blueprint $Table) {
            $Table->id();

            $Table->foreignId('appointment_id')->constrained(table: 'visit_appointments', indexName: 'visit_appointment_employee_FK_appointment_id');
            $Table->foreignId('employee_id')->constrained(table: 'visit_employees', indexName: 'visit_appointment_employee_FK_employee_id');

            $Table->index('appointment_id',                  'visit_appointment_employee_FKI_appointment_id');
            $Table->index('employee_id',                     'visit_appointment_employee_FKI_employee_id');
            $Table->index(['appointment_id', 'employee_id'], 'visit_appointment_employee_UKI_appointment_id_employee_id');

            new CodeGenerator($Table, [
                'columns' => [
                    'appointment_id' => [
                        'reverseRelationName' => 'employees',
                    ],
                    'employee_id' => [
                        'reverseRelationName' => 'appointments',
                    ]
                ],
                'exclude' => [
                    'laravel.action.update',
                ],
                'pivot' => [
                    'relations' => [
                        'appointment_id' => 'visit_appointments',
                        'employee_id' => 'visit_employees',
                    ],
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
                'traits' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\Traits\\HasOrderedScope',
                    ],
                ],
            ]);

        });
    } // up()


};
