<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Database\Seeders;


use Illuminate\Database\Seeder;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class DatabaseSeeder extends Seeder
{

    /**
     * Seed the application's database.
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run(): void
    {
        $env = strtolower(config('app.env'));

        if ($env === 'production') {
            $seeds = [
                ModuleRegisterSeeder::class,
                VisitLanguageSeeder::class,
                VisitTypeSeeder::class,
                VisitReasonSeeder::class,
                VisitLocationTypeSeeder::class,
                VisitLocationSeeder::class,
                VisitEquipmentItemSeeder::class,
                VisitEntryPointSeeder::class,
                VisitOpeningHourSeeder::class,
                // RoleSeeder::class,
                // RoleUserSeeder::class,
            ];
        } elseif ($env === 'demo') {
            $seeds = [
                ModuleRegisterSeeder::class,
                VisitLanguageSeeder::class,
                Dev\VisitContactOptionSeeder::class,
                Dev\VisitContactGroupSeeder::class,
                Dev\VisitEmployeeSeeder::class,
                VisitTypeSeeder::class,
                Dev\VisitReasonSeeder::class,
                VisitLocationTypeSeeder::class,
                Dev\VisitLocationSeeder::class,
                Dev\VisitEquipmentItemSeeder::class,
                Dev\VisitEntryPointSeeder::class,
                VisitOpeningHourSeeder::class,
                Dev\VisitVisitorSeeder::class,
                Dev\VisitAppointmentSeeder::class,
                // RoleSeeder::class,
                // RoleUserSeeder::class,
            ];
        } else {
            $seeds = [
                ModuleRegisterSeeder::class,
                VisitLanguageSeeder::class,
                Dev\VisitContactOptionSeeder::class,
                Dev\VisitContactGroupSeeder::class,
                Dev\VisitEmployeeSeeder::class,
                VisitTypeSeeder::class,
                Dev\VisitReasonSeeder::class,
                VisitLocationTypeSeeder::class,
                Dev\VisitLocationSeeder::class,
                Dev\VisitEquipmentItemSeeder::class,
                Dev\VisitEntryPointSeeder::class,
                VisitOpeningHourSeeder::class,
                Dev\VisitVisitorSeeder::class,
                Dev\VisitAppointmentSeeder::class,
                // RoleSeeder::class,
                // RoleUserSeeder::class,
            ];
        }
        $this->call($seeds);

    } // run()

} // class DatabaseSeeder extends Seeder {}
