<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Database\Seeders;


use BplanModules\VisitorManagement\Enums\LanguageContext;
use BplanModules\VisitorManagement\Models\VisitLanguage;
use Illuminate\Database\Seeder;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitLanguageSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        VisitLanguage::insert([
            [
                "id" => 1,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "bg",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg": "Български", "de": "Bulgarisch", "en": "Bulgarian", "es": "Búlgaro", "fr": "Bulgare", "hu": "Bolgár", "it": "Bulgaro", "lt": "Bulgarų", "pl": "Bułgarski", "ro": "Bulgară", "ru": "Болгарский", "tr": "Bulgarca", "uk": "Болгарська"}',
            ], [
                "id" => 2,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "de",
                "context" => LanguageContext::Both->value,
                "labels" => '{"bg": "Немски", "de": "Deutsch", "en": "German", "es": "Alemán", "fr": "Allemand", "hu": "Német", "it": "Tedesco", "lt": "Vokiečių", "pl": "Niemiecki", "ro": "Germană", "ru": "Немецкий", "tr": "Almanca", "uk": "Німецька"}',
            ], [
                "id" => 3,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "en",
                "context" => LanguageContext::Both->value,
                "labels" => '{"bg": "Английски", "de": "Englisch", "en": "English", "es": "Inglés", "fr": "Anglais", "hu": "Angol", "it": "Inglese", "lt": "Anglų", "pl": "Angielski", "ro": "Engleză", "ru": "Английский", "tr": "İngilizce", "uk": "Англійська"}',
            ], [
                "id" => 4,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "es",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg": "Испански", "de": "Spanisch", "en": "Spanish", "es": "Español", "fr": "Espagnol", "hu": "Spanyol", "it": "Spagnolo", "lt": "Ispanų", "pl": "Hiszpański", "ro": "Spaniolă", "ru": "Испанский", "tr": "İspanyolca", "uk": "Іспанська"}',
            ],[
                "id" => 5,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "fr",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg": "Френски", "de": "Französisch", "en": "French", "es": "Francés", "fr": "Français", "hu": "Francia", "it": "Francese", "lt": "Prancūzų", "pl": "Francuski", "ro": "Franceză", "ru": "Французский", "tr": "Fransızca", "uk": "Французька"}',
            ], [
                "id" => 6,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "it",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg": "Италиански", "de": "Italienisch", "en": "Italian", "es": "Italiano", "fr": "Italien", "hu": "Olasz", "it": "Italiano", "lt": "Italų", "pl": "Włoski", "ro": "Italiană", "ru": "Итальянский", "tr": "İtalyanca", "uk": "Італійська"}',
            ],  [
                "id" => 7,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "lt",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg": "Литовски", "de": "Litauisch", "en": "Lithuanian", "es": "Lituano", "fr": "Lituanien", "hu": "Litván", "it": "Lituano", "lt": "Lietuvių", "pl": "Litewski", "ro": "Lituaniană", "ru": "Литовский", "tr": "Litvanca", "uk": "Литовська"}',
            ], [
                "id" => 8,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "ro",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg": "Румънски", "de": "Rumänisch", "en": "Romanian", "es": "Rumano", "fr": "Roumain", "hu": "Román", "it": "Rumeno", "lt": "Rumunų", "pl": "Rumuński", "ro": "Română", "ru": "Румынский", "tr": "Romence", "uk": "Румунська"}',
            ], [
                "id" => 9,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "ru",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg": "Руски", "de": "Russisch", "en": "Russian", "es": "Ruso", "fr": "Russe", "hu": "Orosz", "it": "Russo", "lt": "Rusų", "pl": "Rosyjski", "ro": "Rusă", "ru": "Русский", "tr": "Rusça", "uk": "Російська"}',
            ], [
                "id" => 10,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "tr",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg": "Турски", "de": "Türkisch", "en": "Turkish", "es": "Turco", "fr": "Turc", "hu": "Török", "it": "Turco", "lt": "Turkų", "pl": "Turecki", "ro": "Turcă", "ru": "Турецкий", "tr": "Türkçe", "uk": "Турецька"}',
            ], [
                "id" => 11,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "hu",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg": "Унгарски", "de": "Ungarisch", "en": "Hungarian", "es": "Húngaro", "fr": "Hongrois", "hu": "Magyar", "it": "Ungherese", "lt": "Vengrų", "pl": "Węgierski", "ro": "Maghiară", "ru": "Венгерский", "tr": "Macarca", "uk": "Угорська"}',
            ], [
                "id" => 12,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "pl",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg": "Полски", "de": "Polnisch", "en": "Polish", "es": "Polaco", "fr": "Polonais", "hu": "Lengyel", "it": "Polacco", "lt": "Lenkų", "pl": "Polski", "ro": "Poloneză", "ru": "Польский", "tr": "Lehçe", "uk": "Польська"}',
            ], [
                "id" => 13,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "uk",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg": "Украински", "de": "Ukrainisch", "en": "Ukrainian", "es": "Ucraniano", "fr": "Ukrainien", "hu": "Ukrán", "it": "Ucraino", "lt": "Ukrainiečių", "pl": "Ukraiński", "ro": "Ucraineană", "ru": "Украинский", "tr": "Ukraynaca", "uk": "Українська"}',
            ],

        ]);

    } // run()

} // class LanguageSeeder extends Seeder {}
