<div x-data="createAccessAuthorization" x-cloak x-show="show" id="createAccessAuthorizationModal" tabindex="-1"
    x-on:show-create-access-authorization-modal.window="showModal()"
    x-on:access-authorization-created.window="created($event)"
    class="fixed top-0 left-0 right-0 z-50 flex items-center justify-center w-full h-screen overflow-x-hidden overflow-y-auto md:inset-0 md:h-full">
    <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75"></div>
    <div class="relative w-full h-full max-w-2xl p-4 md:h-auto">
        <!-- Modal content -->
        <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
            <!-- Modal header -->
            <div class="flex items-center justify-between pb-4 mb-4 border-b rounded-t sm:mb-5 dark:border-gray-600">

                <div class="flex items-center space-x-2 text-gray-900 dark:text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6">
                        <path
                            d="M3.375 4.5C2.339 4.5 1.5 5.34 1.5 6.375V13.5h12V6.375c0-1.036-.84-1.875-1.875-1.875h-8.25ZM13.5 15h-12v2.625c0 1.035.84 1.875 1.875 1.875h.375a3 3 0 1 1 6 0h3a.75.75 0 0 0 .75-.75V15Z" />
                        <path
                            d="M8.25 19.5a1.5 1.5 0 1 0-3 0 1.5 1.5 0 0 0 3 0ZM15.75 6.75a.75.75 0 0 0-.75.75v11.25c0 .087.015.17.042.248a3 3 0 0 1 5.958.464c.853-.175 1.522-.935 1.464-1.883a18.659 18.659 0 0 0-3.732-10.104 1.837 1.837 0 0 0-1.47-.725H15.75Z" />
                        <path d="M19.5 19.5a1.5 1.5 0 1 0-3 0 1.5 1.5 0 0 0 3 0Z" />
                    </svg>

                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        @lang('visitor-management::visit-access-authorizations.modal.create.heading')
                    </h3>
                </div>
                <button x-on:click="hideModal()" type="button"
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">
                        @lang('globals::global.action.close')
                    </span>
                </button>
            </div>
            <!-- Modal body -->
            <div>
                <h3 class="text-md font-semibold text-gray-900 dark:text-white">
                    {{ $accessAuthorization->subject ?? '' }}
                </h3>
                <div class="grid gap-4 mb-4 sm:grid-cols-2">
                    <div class="col-start-1 flex items-center">
                        <input :disabled="createSucceeded" type="checkbox" wire:model="isActive"
                            id="isActive"
                            class="w-4 h-4 bg-gray-100 border-gray-300 rounded text-primary-600 focus:ring-primary-500 dark:focus:ring-primary-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600"
                            placeholder="@lang('globals::global.status.active')">
                        <label for="isActive"
                            class="text-sm font-medium text-gray-900 ms-2 dark:text-gray-300">
                            @lang('globals::global.status.active')
                        </label>
                        <x-input-error for="isActive" />
                    </div>
                    <div class="col-start-1">
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="name" class="text-sm font-medium text-gray-900 dark:text-white inline-flex">
                                @lang('visitor-management::visit-access-authorizations.label.employee')
                            </label>
                        </div>
                        <select :disabled="createSucceeded" wire:model.live="employeeId" id="employeeId" x-on:change="initFlatpickrs"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('visitor-management::visit-access-authorizations.placeholder.employee')" required="">
                            <option>
                                -
                            </option>
                            @foreach ($employees as $employee)
                                <option value="{{ $employee->id }}">
                                    {{ $employee->last_name }}, {{ $employee->first_name }} ({{ $employee->email }})
                                </option>
                            @endforeach
                        </select>
                        <x-input-error for="employeeId" />
                    </div>
                    <div x-show="employeeId != null" class="col-start-1 col-span-2">
                        <h3 class="mb-4 font-semibold text-gray-900 dark:text-white">
                            @lang('visitor-management::visit-access-authorizations.label.license-plate')
                        </h3>
                        <ul
                            class="w-full gap-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-lg dark:bg-gray-700 dark:border-gray-600 dark:text-white">
                            @if (isset($employeeLicensePlates))
                                @foreach ($employeeLicensePlates as $index => $licensePlate)
                                    <li
                                        class="w-full gap-2 grid grid-cols-3 border-b border-gray-200 rounded-t-lg dark:border-gray-600 p-2">
                                        <div class="flex items-center ps-3">
                                            <input id="license_plate-{{ $index }}-checkbox" type="checkbox"
                                                wire:model="selectedEmployeeLicensePlates.{{ $index }}"
                                                class="w-4 h-4 text-primary-600 bg-gray-100 border-gray-300 rounded focus:ring-primary-500 dark:focus:ring-primary-600 dark:ring-offset-gray-700 dark:focus:ring-offset-gray-700 focus:ring-2 dark:bg-gray-600 dark:border-gray-500">
                                            <label for="license_plate-{{ $index }}-checkbox"
                                                class="w-full py-3 ms-2 text-sm font-medium text-gray-900 dark:text-gray-300">{{ $licensePlate }}</label>
                                        </div>
                                        <div>
                                            <div class="flex items-center mb-2 space-x-1">
                                                <label for="startDates.{{ $index }}"
                                                    class="block text-sm font-medium text-gray-900 dark:text-white">
                                                    @lang('visitor-management::visit-access-authorizations.label.start-date')
                                                    <x-global-components::global.input-required-hint />
                                                </label>
                                            </div>
                                            <input :disabled="createSucceeded" type="text" readonly="readonly"
                                                wire:model="startDates.{{ $index }}"
                                                id="startDates.{{ $index }}"
                                                class="flatpickr-input flatpickr-startdates bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                                placeholder="@lang('visitor-management::visit-access-authorizations.placeholder.start-date')" required="">
                                            <x-input-error for="startDates.{{ $index }}" />
                                        </div>
                                        <div>
                                            <div class="flex items-center mb-2 space-x-1">
                                                <label for="endDates.{{ $index }}"
                                                    class="block text-sm font-medium text-gray-900 dark:text-white">
                                                    @lang('visitor-management::visit-access-authorizations.label.end-date')
                                                    <x-global-components::global.input-required-hint />
                                                </label>
                                            </div>
                                            <input :disabled="createSucceeded" type="text" readonly="readonly"
                                                wire:model="endDates.{{ $index }}"
                                                id="endDates.{{ $index }}"
                                                class="flatpickr-input flatpickr-enddates bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                                placeholder="@lang('visitor-management::visit-access-authorizations.placeholder.end-date')" required="">
                                            <x-input-error for="endDates.{{ $index }}" />
                                        </div>
                                    </li>
                                @endforeach
                            @endif
                        </ul>
                        <x-input-error for="selectedEmployeeLicensePlates" />
                    </div>
                    <div x-show="employeeId == null" :disabled="createSucceeded">
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="name" class="text-sm font-medium text-gray-900 dark:text-white inline-flex">
                                @lang('visitor-management::visit-access-authorizations.label.license-plate')
                                <x-global-components::global.input-required-hint />
                                {{-- <x-global-components::global.information-icon
                                    data-tippy-content="{{ __('global.license_plate_information') }}" /> --}}
                            </label>
                        </div>
                        <x-visitor-management::global.input-license-plates :licensePlates="$licensePlates" target="create" />
                        <x-input-error for="licensePlates" />
                    </div>
                    <div x-show="employeeId == null">
                        <div>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="startDate" class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-access-authorizations.label.start-date')
                                    <x-global-components::global.input-required-hint />
                                </label>
                            </div>
                            <input :disabled="createSucceeded" type="text" wire:model="startDate" id="startDate" readonly="readonly"
                                class="flatpickr-input flatpickr-startdates bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-access-authorizations.placeholder.start-date')" required="">
                            <x-input-error for="startDate" />
                        </div>
                    </div>
                    <div x-show="employeeId == null">
                        <div>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="endDate" class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-access-authorizations.label.end-date')
                                    <x-global-components::global.input-required-hint />
                                </label>
                            </div>
                            <input :disabled="createSucceeded" type="text" wire:model="endDate" id="endDate" readonly="readonly"
                                class="flatpickr-input flatpickr-enddates bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-access-authorizations.placeholder.end-date')" required="">
                            <x-input-error for="endDate" />
                        </div>
                    </div>
                </div>
            </div>
            <div class="flex justify-end">
                <button wire:loading.remove wire:target="createAccessAuthorization"
                    wire:click="createAccessAuthorization" type="button"
                    class="text-white inline-flex items-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                    <svg class="w-6 h-6 mr-1 -ml-1" fill="currentColor" viewBox="0 0 20 20"
                        xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M10 5a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3H6a1 1 0 110-2h3V6a1 1 0 011-1z"
                            clip-rule="evenodd"></path>
                    </svg>
                    @lang('globals::global.action.add')
                </button>
                <x-global-components::global.loading-spinner wire:loading wire:target="createAccessAuthorization" />
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('alpine:init', () => {
        Alpine.data('createAccessAuthorization', () => ({
            show: false,
            employeeId: @entangle('employeeId'),
            createSucceeded: false,
            init() {
                flatpickr(".flatpickr-startdates", {
                    locale: @js(app()->getLocale()),
                    dateFormat: "Y-m-d",
                    altInput: true,
                    altFormat: @js(__('globals::global.date.format')),
                });

                flatpickr(".flatpickr-enddates", {
                    locale: @js(app()->getLocale()),
                    dateFormat: "Y-m-d",
                    altInput: true,
                    altFormat: @js(__('globals::global.date.format')),
                });
            },

            // CREATE
            created(event) {
                this.createSucceeded = true;
                this.hideModal();
            },
            resetModal() {
                this.createSucceeded = false;

                @this.resetModal()
            },
            hideModal() {
                this.show = false;
                this.resetModal();
            },
            showModal(id) {
                this.show = true;

                setTimeout(() => {
                    document.getElementById('employeeId').focus();
                }, 100);
            },
            initFlatpickrs() {
                setTimeout(() => {
                    flatpickr(".flatpickr-startdates", {
                        locale: @js(app()->getLocale()),
                        dateFormat: "Y-m-d",
                        altInput: true,
                        altFormat: @js(__('globals::global.date.format')),
                    });

                    flatpickr(".flatpickr-enddates", {
                        locale: @js(app()->getLocale()),
                        dateFormat: "Y-m-d",
                        altInput: true,
                        altFormat: @js(__('globals::global.date.format')),
                    });
                }, 500)
            }
        }));
    });
</script>
</div>
