<div>
    <div class="my-4">
        <h2 class="text-4xl font-extrabold dark:text-white">
            @lang('visitor-management::visit-opening-hours.page.heading')
        </h2>
        <p class="my-4 text-lg text-gray-500">
            @lang('visitor-management::visit-opening-hours.page.description')
        </p>
    </div>

    <div class="flex justify-center">
        <div
            class="max-w-4xl p-6 bg-white border border-gray-200 rounded-lg shadow-sm dark:bg-gray-800 dark:border-gray-700 mb-4">
            <div class="flex justify-between mb-2 space-x-8">
                <h5 class="text-2xl font-bold tracking-tight text-gray-900 dark:text-white">
                    @lang('visitor-management::visit-opening-hours.upcoming-exceptions')
                </h5>

                <button type="button" x-on:click="$dispatch('show-add-opening-hours-exception-modal')"
                    data-tippy-content="{{ __('visitor-management::visit-opening-hours.action.create-exception') }}"
                    class="text-white bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-full text-sm p-2.5 text-center inline-flex items-center me-2 dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                    <svg class="size-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                        <path fill-rule="evenodd"
                            d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                            clip-rule="evenodd" />
                    </svg>

                    <span class="sr-only">
                        @lang('visitor-management::visit-opening-hours.action.add-exception')
                    </span>
                </button>
            </div>

            <div class="mt-4">
                @foreach ($openingHoursExceptions as $openingHoursException)
                    <div class="mb-4">
                        <div class="grid grid-cols-5 items-center">
                            <div>
                                @lang("visitor-management::visit-types.identifier.{$openingHoursException->visitType->identifier}")
                            </div>
                            <div>
                                {{ $openingHoursException->date->format(__('globals::global.date.format')) }} (@lang("globals::global.weekdays.{$_weekdays[$openingHoursException->date->dayOfWeek()]}"))
                            </div>
                            <div class="flex justify-center">
                                @if ($openingHoursException->open ?? false)
                                    <span
                                        class="bg-green-100 text-green-800 text-sm font-medium me-2 px-2.5 py-0.5 rounded-sm dark:bg-green-900 dark:text-green-300">
                                        @lang('visitor-management::visit-opening-hours.status.opened')
                                    </span>
                                @else
                                    <span
                                        class="bg-red-100 text-red-800 text-sm font-medium me-2 px-2.5 py-0.5 rounded-sm dark:bg-red-900 dark:text-red-300">
                                        @lang('visitor-management::visit-opening-hours.status.closed')
                                    </span>
                                @endif
                            </div>
                            <div class="flex justify-center">
                                @if ($openingHoursException->open ?? false)
                                    <div>
                                        {{ Carbon\Carbon::parse($openingHoursException->begin)->format('H:i') }}
                                    </div>
                                    <p class="mx-2">
                                        &nbsp;@lang('visitor-management::visit-opening-hours.until')&nbsp;
                                    </p>
                                    <div>
                                        {{ Carbon\Carbon::parse($openingHoursException->end)->format('H:i') }}
                                    </div>
                                @endif
                            </div>
                            <div x-data="{ showRemove: false }" x-cloak class="flex justify-end">
                                <div class="flex items-center justify-end ml-8">
                                    <button x-show="!showRemove" wire:loading.remove
                                        wire:target="delete(@js($openingHoursException->id))"
                                        class="text-red-600 dark:text-red-500 hover:underline"
                                        x-on:click="showRemove = true">
                                        @lang('globals::global.action.delete')
                                    </button>
                                    <div x-cloak x-show="showRemove" wire:loading.remove
                                        wire:target="deleteContactGroup">
                                        <p class="text-xs text-gray-900 dark:text-white">
                                            @lang('globals::global.confirm.delete')</p>
                                        <div>
                                            <button x-on:click="showRemove = false"
                                                class="text-xs font-medium text-primary-700 dark:text-primary-600 hover:underline">
                                                @lang('globals::global.action.cancel')
                                            </button>
                                            <button x-on:click="showRemove = false"
                                                wire:click="delete(@js($openingHoursException->id))"
                                                class="text-xs font-medium text-red-600 dark:text-red-500 hover:underline">
                                                @lang('globals::global.action.delete')
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <div class="gap-4 grid xl:grid-cols-2">
        @foreach ($visitTypes as $visitType)
            <div
                class="max-w-4xl p-6 bg-white border border-gray-200 rounded-lg shadow-sm dark:bg-gray-800 dark:border-gray-700">
                <h5 class="mb-2 text-2xl font-bold tracking-tight text-gray-900 dark:text-white">
                    @lang("visitor-management::visit-types.identifier.{$visitType->identifier}")
                </h5>
                @forelse ($visitType->openingHours as $openingHour)
                    <div class="mb-4">
                        <div class="grid grid-cols-3 items-center">
                            <div>
                                @lang("globals::global.weekdays.{$_weekdays[$openingHour->weekday]}")
                            </div>
                            <div class="flex justify-center">
                                @if ($openingHours[$visitType->identifier][$openingHour->weekday]['open'] ?? false)
                                    <span
                                        class="bg-green-100 text-green-800 text-sm font-medium me-2 px-2.5 py-0.5 rounded-sm dark:bg-green-900 dark:text-green-300">
                                        @lang('visitor-management::visit-opening-hours.status.opened')
                                    </span>
                                @else
                                    <span
                                        class="bg-red-100 text-red-800 text-sm font-medium me-2 px-2.5 py-0.5 rounded-sm dark:bg-red-900 dark:text-red-300">
                                        @lang('visitor-management::visit-opening-hours.status.closed')
                                    </span>
                                @endif
                            </div>
                            <div class="flex justify-center">
                                @if ($openingHours[$visitType->identifier][$openingHour->weekday]['open'] ?? false)
                                    <div>
                                        {{ Carbon\Carbon::parse($openingHour->begin)->format('H:i') }}
                                    </div>
                                    <p class="mx-2">
                                        &nbsp;@lang('visitor-management::visit-opening-hours.until')&nbsp;
                                    </p>
                                    <div>
                                        {{ Carbon\Carbon::parse($openingHour->end)->format('H:i') }}
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                @empty
                    <p class="mb-3 font-normal text-gray-700 dark:text-gray-400">
                        @lang('visitor-management::visit-opening-hours.no_opening_hours_defined')
                    </p>
                @endforelse

                <div class="flex justify-end">
                    <button
                        x-on:click="$dispatch('show-edit-opening-hours-modal', { visitType: @js($visitType) })"
                        class="inline-flex items-center px-3 py-2 text-sm font-medium text-center text-white bg-primary-700 rounded-lg hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                        @lang('globals::global.action.edit')
                    </button>
                </div>
            </div>
        @endforeach
    </div>

    <livewire:visitor-management::visit-opening-hours.modals.edit />
    <livewire:visitor-management::visit-opening-hours.modals.create-exception />
</div>
