<div x-data="editVisitType" x-cloak x-show="show" id="editVisitTypeModal" tabindex="-1"
    x-on:show-edit-visit-type-modal.window="showModal()" x-on:visit-type-edited.window="edited($event)"
    class="fixed top-0 left-0 right-0 z-50 flex items-center justify-center w-full h-screen overflow-x-hidden overflow-y-auto md:inset-0 md:h-full">
    <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75"></div>
    <div class="relative w-full h-full max-w-2xl p-4 md:h-auto">
        <!-- Modal content -->
        <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
            <!-- Modal header -->
            <div class="flex items-center justify-between pb-4 mb-4 border-b rounded-t sm:mb-5 dark:border-gray-600">

                <div class="flex items-center space-x-2 text-gray-900 dark:text-white">
                    {{-- map-pin --}}
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6">
                        <path fill-rule="evenodd"
                            d="m11.54 22.351.07.04.028.016a.76.76 0 0 0 .723 0l.028-.015.071-.041a16.975 16.975 0 0 0 1.144-.742 19.58 19.58 0 0 0 2.683-2.282c1.944-1.99 3.963-4.98 3.963-8.827a8.25 8.25 0 0 0-16.5 0c0 3.846 2.02 6.837 3.963 8.827a19.58 19.58 0 0 0 2.682 2.282 16.975 16.975 0 0 0 1.145.742ZM12 13.5a3 3 0 1 0 0-6 3 3 0 0 0 0 6Z"
                            clip-rule="evenodd" />
                    </svg>
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        @lang('visitor-management::visit-types.modal.edit.heading')
                    </h3>
                </div>
                <button x-on:click="hideModal()" type="button"
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">
                        @lang('globals::global.action.close')
                    </span>
                </button>
            </div>
            <!-- Modal body -->
            <div>
                <div class="grid gap-4 mb-4 sm:grid-cols-2">
                    <div class="col-span-2">
                        <h3 class="text-2xl font-bold text-center">
                            @lang('visitor-management::visit-types.identifier.' . $visitType?->identifier)
                        </h3>
                    </div>
                    <div class="grid gap-4 mb-4 sm:grid-cols-2">
                        <div>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="labelsJson"
                                    class="block text-sm font-medium text-gray-900 dark:text-white truncate text-ellipsis">
                                    @lang('visitor-management::visit-types.label.safety-briefings')
                                    <x-global-components::global.input-required-hint />
                                </label>
                            </div>
                            <x-visitor-management::global.input-multi-language-json :labelsJson="$safetyBriefingsJson" target="edit" />
                        </div>
                    </div>
                    {{-- HR --}}
                    <div class="sm:col-span-2">
                        <div class="inline-flex items-center justify-center w-full">
                            <hr class="w-full h-px my-8 bg-gray-200 border-0 dark:bg-gray-700">
                            <span
                                class="absolute px-3 font-medium text-gray-900 -translate-x-1/2 bg-white left-1/2 dark:text-white dark:bg-gray-900">
                                @lang('visitor-management::visit-types.section-heading.mail-attachments')
                            </span>
                        </div>
                    </div>
                    <div class="col-span-2">
                        <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white" for="files">
                            @lang('globals::global.action.upload')
                        </label>
                        <input
                            class="block w-full text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 dark:text-gray-400 focus:outline-none dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400"
                            id="files" type="file">
                        <x-input-error for="files" />
                    </div>

                </div>
                <div class="flex justify-end">
                    <button wire:loading.remove wire:target="editVisitType" wire:click="editVisitType" type="button"
                        class="text-white inline-flex items-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                            class="w-5 h-5 mr-1 -ml-1">
                            <path fill-rule="evenodd"
                                d="M19.916 4.626a.75.75 0 0 1 .208 1.04l-9 13.5a.75.75 0 0 1-1.154.114l-6-6a.75.75 0 0 1 1.06-1.06l5.353 5.353 8.493-12.74a.75.75 0 0 1 1.04-.207Z"
                                clip-rule="evenodd" />
                        </svg>
                        @lang('globals::global.action.save')
                    </button>
                    <x-global-components::global.loading-spinner wire:loading wire:target="editVisitType" />
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('editVisitType', () => ({
                show: false,
                editSucceeded: false,

                edited(event) {
                    this.editSucceeded = true;
                    this.hideModal();
                },
                resetModal() {
                    this.editSucceeded = false;

                    @this.resetModal()
                },
                hideModal() {
                    this.show = false;
                    this.resetModal();
                },
                showModal(id) {
                    this.show = true;

                    setTimeout(() => {
                        document.getElementById('firstname').focus();
                    }, 100);
                }
            }));
        });
    </script>
</div>
