<?php
/**
 * Route File
 *
 * Wegen der Routen "visit-appointments/employees" und "visit-employees/appointments"
 * aus der automatischen Generierung genommen.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-21 23:08:32
 * @package     bplan-modules/visitor-management
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use Illuminate\Support\Facades\Route;
use LaravelJsonApi\Laravel\Facades\JsonApiRoute;
use LaravelJsonApi\Laravel\Http\Controllers\JsonApiController;
use LaravelJsonApi\Laravel\Routing\Relationships;
use LaravelJsonApi\Laravel\Routing\ResourceRegistrar;


JsonApiRoute::server('data')
    ->prefix('api/data')
    ->middleware('api')
    ->withoutMiddleware(\Illuminate\Routing\Middleware\SubstituteBindings::class)
    ->resources(function (ResourceRegistrar $Server) {

        $Server->resource('visit-appointment-employees', JsonApiController::class)->except('update')
            ->relationships(function (Relationships $Relations) {
                $Relations->hasOne('appointment')->readOnly();
                $Relations->hasOne('employee')->readOnly();
            });

        $Server->resource('visit-appointment-equipment-items', JsonApiController::class)
            ->relationships(function (Relationships $Relations) {
                $Relations->hasOne('appointment')->readOnly();
                $Relations->hasOne('equipment-item')->readOnly();
            });

        $Server->resource('visit-appointment-status-logs', JsonApiController::class)->except('destroy', 'update')
            ->relationships(function (Relationships $Relations) {
                $Relations->hasOne('appointment')->readOnly();
                $Relations->hasOne('entry-point')->readOnly();
            });

        $Server->resource('visit-appointments', JsonApiController::class)
            ->relationships(function (Relationships $Relations) {
                $Relations->hasOne('bulk-appointment')->readOnly();
                $Relations->hasMany('bulk-appointments')->readOnly();
                $Relations->hasOne('check-in-entry-point')->readOnly();
                $Relations->hasOne('check-out-entry-point')->readOnly();
                $Relations->hasOne('create-user')->readOnly();
                $Relations->hasOne('loading-ramp')->readOnly();
                $Relations->hasOne('main-employee')->readOnly();
                $Relations->hasOne('main-visitor')->readOnly();
                $Relations->hasOne('organizer-employee')->readOnly();
                //$Relations->hasMany('employees')->readOnly();
                $Relations->hasOne('visit-reason')->readOnly();
            });

        $Server->resource('visit-contact-groups', JsonApiController::class)
            ->relationships(function (Relationships $Relations) {
                $Relations->hasMany('employees')->readOnly();
            });

        $Server->resource('visit-contact-options', JsonApiController::class);

        $Server->resource('visit-employees', JsonApiController::class)
            ->relationships(function (Relationships $Relations) {
                $Relations->hasMany('assigned-appointments')->readOnly();
                $Relations->hasOne('contact-group')->readOnly();
                $Relations->hasMany('organized-appointments')->readOnly();
                $Relations->hasOne('user')->readOnly();
                $Relations->hasMany('appointments')->readOnly();
            });

        $Server->resource('visit-entry-points', JsonApiController::class)
            ->relationships(function (Relationships $Relations) {
                $Relations->hasMany('appointment-check-ins')->readOnly();
                $Relations->hasMany('appointment-check-outs')->readOnly();
                $Relations->hasMany('visit-appointment-status-logs')->readOnly();
            });

        $Server->resource('visit-equipment-items', JsonApiController::class)
            ->relationships(function (Relationships $Relations) {
                $Relations->hasMany('visit-appointments')->readOnly();
            });

        $Server->resource('visit-import-logs', JsonApiController::class)->readOnly();

        $Server->resource('visit-languages', JsonApiController::class);

        $Server->resource('visit-location-types', JsonApiController::class)
            ->relationships(function (Relationships $Relations) {
                $Relations->hasMany('locations')->readOnly();
            });

        $Server->resource('visit-locations', JsonApiController::class)
            ->relationships(function (Relationships $Relations) {
                $Relations->hasMany('appointments')->readOnly();
                $Relations->hasOne('location-type')->readOnly();
                $Relations->hasOne('master')->readOnly();
                $Relations->hasMany('sub-locations')->readOnly();
            });

        $Server->resource('visit-opening-hour-exceptions', JsonApiController::class)
            ->relationships(function (Relationships $Relations) {
                $Relations->hasOne('visit-type')->readOnly();
            });

        $Server->resource('visit-opening-hours', JsonApiController::class)
            ->relationships(function (Relationships $Relations) {
                $Relations->hasOne('visit-type')->readOnly();
            });

        $Server->resource('visit-reasons', JsonApiController::class)
            ->relationships(function (Relationships $Relations) {
                $Relations->hasMany('appointments')->readOnly();
                $Relations->hasOne('visit-type')->readOnly();
            });

        $Server->resource('visit-types', JsonApiController::class)
            ->relationships(function (Relationships $Relations) {
                $Relations->hasMany('appointments')->readOnly();
                $Relations->hasMany('opening-hour-exceptions')->readOnly();
            });

        $Server->resource('visit-visitors', JsonApiController::class)
            ->relationships(function (Relationships $Relations) {
                $Relations->hasMany('assigned-appointments')->readOnly();
            });

    });

if (file_exists(__DIR__.'/custom.data.php')) {
    require_once __DIR__.'/custom.data.php';
}
