<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanModules\VisitorManagement\Http\Controllers\VisitAppointmentController;
use BplanModules\VisitorManagement\Http\Controllers\VisitContactGroupController;
use BplanModules\VisitorManagement\Http\Controllers\VisitContactOptionController;
use BplanModules\VisitorManagement\Http\Controllers\VisitDashboardController;
use BplanModules\VisitorManagement\Http\Controllers\VisitDocumentController;
use BplanModules\VisitorManagement\Http\Controllers\VisitEmployeeController;
use BplanModules\VisitorManagement\Http\Controllers\VisitEquipmentItemController;
use BplanModules\VisitorManagement\Http\Controllers\VisitLocationController;
use BplanModules\VisitorManagement\Http\Controllers\VisitOpeningHourController;
use BplanModules\VisitorManagement\Http\Controllers\VisitReasonController;
use BplanModules\VisitorManagement\Http\Controllers\VisitTypeController;
use BplanModules\VisitorManagement\Http\Controllers\VisitVisitorController;
use Illuminate\Support\Facades\Route;


$packagePrefix = 'visit';


/**
 * No specific role needed
 */
Route::prefix($packagePrefix)
    ->middleware([
        'web',
        'auth:sanctum',
        config('jetstream.auth_session'),
        'verified',

    ])->group(function () {
        Route::get('/dashboard', [VisitDashboardController::class, 'index'])->name('visit-dashboard');
    }
);


/**
 * Admin role needed
 */
Route::prefix($packagePrefix)
    ->middleware([
        'web',
        'auth:sanctum',
        config('jetstream.auth_session'),
        'verified',
        'access-level.or.roles:SystemManager,Admin',

    ])->group(function () {
        Route::get('/access-authorizations', [VisitAppointmentController::class,   'indexAccessAuthorizations'])->name('visit-access-authorizations.index');
        Route::get('/documents',             [VisitDocumentController::class,      'index'])->name('visit-documents.index');
        Route::get('/locations',             [VisitLocationController::class,      'index'])->name('visit-locations.index');
        Route::get('/contact-groups',        [VisitContactGroupController::class,  'index'])->name('visit-contact-groups.index');
        Route::get('/contact-options',       [VisitContactOptionController::class, 'index'])->name('visit-contact-options.index');
        Route::get('/employees',             [VisitEmployeeController::class,      'index'])->name('visit-employees.index');
        Route::get('/equipment-items',       [VisitEquipmentItemController::class, 'index'])->name('visit-equipment-items.index');
        Route::get('/opening-hours',         [VisitOpeningHourController::class,   'index'])->name('visit-opening-hours.index');
        Route::get('/reasons',               [VisitReasonController::class,        'index'])->name('visit-reasons.index');
        Route::get('/types',                 [VisitTypeController::class,          'index'])->name('visit-types.index');
    }
);


/**
 * Host role needed
 */
Route::prefix($packagePrefix)
    ->middleware([
        'web',
        'auth:sanctum',
        config('jetstream.auth_session'),
        'verified',
        'access-level.or.roles:SystemManager,Host',

    ])->group(function () {
        Route::get('/visitors', [VisitVisitorController::class, 'index'])->name('visit-visitors.index');
    }
);


/**
 * Logistics role needed
 */
Route::prefix($packagePrefix)
    ->middleware([
        'web',
        'auth:sanctum',
        config('jetstream.auth_session'),
        'verified',
        'access-level.or.roles:SystemManager,Logistics',

    ])->group(function () {
        Route::get('/logistic-queue', [VisitAppointmentController::class, 'indexLogisticQueue'])->name('visit-logistic-queue.index');
    }
);


/**
 * Host or Report role needed
 */
Route::prefix($packagePrefix)
    ->middleware([
        'web',
        'auth:sanctum',
        config('jetstream.auth_session'),
        'verified',
        'access-level.or.roles:SystemManager,Host,Report',

    ])->group(function () {
        Route::get('/appointments', [VisitAppointmentController::class, 'index'])->name('visit-appointments.index');
    }
);


/**
 * Guest routes
 */
Route::prefix($packagePrefix)
    ->group(function () {
        Route::get('/personalize',              [VisitVisitorController::class,  'personalize'])->name('visit-visitors.personalize');
        Route::get('/documents/{documentName}', [VisitDocumentController::class, 'show'])->name('visit-documents.show');
    }
);
