<?php
/**
 * Update Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-19 23:55:43
 * @package     bplan-modules/visitor-management
 * @subpackage  Actions
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Actions\VisitOpeningHour;


use BplanModules\VisitorManagement\Models\VisitOpeningHour;


/**
 * Update Action Class
 *
 * @version     1.1.0 / 2025-04-19
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Update
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       int|string|VisitOpeningHour $visitOpeningHour
     *
     * @param       array $attributes
     *
     * @return      VisitOpeningHour
     *
     * @version     2.1.0 / 2025-04-19
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(int|string|VisitOpeningHour $visitOpeningHour, array $attributes): VisitOpeningHour
    {
        /*
        **  Datum und VisitType dürfen nie geändert werden. */
        unset($attributes['date']);
        unset($attributes['visit_type_id']);

        if ($visitOpeningHour instanceof VisitOpeningHour) {
            $Model = $visitOpeningHour;
        } else {
            $Model = VisitOpeningHour::findOrFail($visitOpeningHour);
        }
        $Model->fill($attributes);

        $Model->save();

        return $Model;

    } // execute()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Update {}
