<?php
/**
 * Command Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     Avient
 * @subpackage  Commands
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Console\Commands;


use BplanModules\VisitorManagement\Services\VisitAppointmentService;
use Illuminate\Console\Command;


/**
 * Führt einen CheckOut bei allen offenen Terminen durch
 *
 * Dieser Prozess sollte nur einmalig, kurz nach Mitternacht, gestartet werden.
 * Außerdem sollte er vor dem Prozess "FinishAppointments" gestartet werden.
 *
 * Die ermittelten Termine erhalten den Status "CheckedOut", unabhängig davon wann das
 * avisierte Terminende ist. Durch den Prozess "FinishAppointments" werden die Termine
 * mit abgelaufenen Terminende dann finalisiert.
 *
 * @version     1.1.0 / 2025-03-22
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class CheckOutOpenAppointments extends Command
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $description
     */
    protected $description = 'Open appointment closer';


    /**
     * @var     string $signature
     */
    protected $signature = 'checkout:open-appointments';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-03-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function handle()
    {
        $this->output->title('Starting');
        $this->output->info('Checking out open appointments.');

        $AppointmentService = new VisitAppointmentService();

        $count = $AppointmentService->CheckOutOpen();

        $this->output->success('Checked out '.$count.' appointment(s).');

    } // handle()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class CheckOutOpenAppointments extends Command {}
