<?php
/**
 * Command Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Commands
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Console\Commands;


use BplanModules\VisitorManagement\Services\VisitAppointmentService;
use Illuminate\Console\Command;


/**
 * Finalisiert Termine, die am Ende des Tages noch offen sind
 *
 * @version     1.1.0 / 2024-10-16
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class FinishAppointments extends Command
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $description
     */
    protected $description = 'Appointment finisher';


    /**
     * @var     string $signature
     */
    protected $signature = 'finish:appointments';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.1.0 / 2024-10-16
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function handle()
    {
        $this->output->title('Starting');

        $AppointmentService = new VisitAppointmentService();

        $count = $AppointmentService->finishPast();

        $this->output->info('Finished '.$count.' appointment(s).');

        $this->output->success('');

    } // handle()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class FinishAppointments extends Command {}
