<?php
/**
 * Enum Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Enums
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Enums;


/**
 * Enum Class
 *
 * Beschreibung der Statuswerte:
 *
 * 0 Open           Das ist der Standardwert bei der Anlage eines Termins.
 *
 * 1 Initialized    Dieser Status wird gesetzt, wenn der CheckIn-Prozess am Terminal initiiert
 *                  wurde.
 *
 * 2 CheckedIn      Wenn der CheckIn-Prozess am Terminal beendet ist, dann wird normalerweise
 *                  dieser Status gesetzt.
 *                  Ausnahme: Wenn Besucher nach dem Terminal keine zusätzliche Schleuse/Schranke
 *                  mehr passieren müssen, dann wird dieser Status übersprungen.
 *
 * 3 CalledIn       Bei Prozessen, bei denen noch eine zusätzliche Zufahrts-/Zutrittsgenehmigung
 *                  erteilt werden muss, wird dieser Status gesetzt, sobald die Genehmigung erteilt
 *                  wurde.
 *
 * 4 Entered        Status nach dem Betreten (Schleuse) oder Befahren (Schranke) des Gebäudes/Geländes.
 *                  Ohne Schleuse und ohne explizit zu erteilende Genehmigung wird nach dem CheckIn
 *                  direkt dieser Status gesetzt.
 *
 * 5 Ongoing        Zwischenstatus, der genutzt werden kann, um zu kennzeichnen, dass der Termin wirklich
 *                  begonnen hat. Dieser Status könnte zum Beispiel dazu verwendet werden LKW, die aktuell
 *                  ent-/beladen werden farblich zu kennzeichnen, um sie von den LKW zu unterscheiden, die
 *                  zwar schon eingefahren sind, sich aber noch auf dem Weg zur Laderampe befinden (wird
 *                  aktuell nicht verwendet, erfordert eine Benutzeraktion).
 *
 * 6 CheckedOut     Status beim manuellen CheckOut am Terminal oder beim Verlassen des Geländes durch
 *                  eine Schleuse/Schranke.
 *                  Dieser Status wird beibehalten, wenn es sich um einen mehrtägigen Termin handelt und
 *                  der letzte Tag des Terminzeitraums noch nicht erreicht ist oder wenn es sich um einen
 *                  Shunting-Termin handelt, bei dem das Gelände innerhalb des Terminzeitraums mehrfach
 *                  befahren werden kann. Andernfalls wird automatisch der Status "Finished" (7) gesetzt.
 *
 * 7 Finished       Abschließender Status. Wird implizit beim CheckOut gesetzt (außer bei mehrtägigen
 *                  Terminen, bei denen der letzte Termintag noch nicht erreicht ist, oder bei Shunting-
 *                  Terminen).
 *
 * Bei mehrtägigen Terminen oder bei Shunting-Terminen wechselt der Status nach dem CheckOut mit jedem
 * neuen Betreten/Befahren immer von 6 nach 4 und beim Verlassen des Gebäudes/Geländes wieder von 4 zu 6,
 * bis letztendlich das Ende des Terminzeitraums erreicht ist und der Termin finalisiert (7) wird.
 *
 *
 * @version     1.0.0 / 2024-12-09
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
enum ProcessStatus: int {

    case Open        = 0;

    case Initialized = 1;

    case CheckedIn   = 2;

    case CalledIn    = 3;

    case Entered     = 4;

    case Ongoing     = 5;

    case CheckedOut  = 6;

    case Finished    = 7;

} // enum ProcessStatus {}
