<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-18 16:14:49
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitAccessAuthorizations\Modals;


use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Enums\VisitTypeIdentifier;
use BplanModules\VisitorManagement\Models\VisitEmployee;
use BplanModules\VisitorManagement\Models\VisitReason;
use BplanModules\VisitorManagement\Repositories\VisitEmployeeRepository;
use BplanModules\VisitorManagement\Services\VisitAppointmentService;
use BplanModules\VisitorManagement\Traits\WithLicensePlateInput;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Validator;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-18
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
class Create extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use InteractsWithBanner;
    use WithLicensePlateInput;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     */
    protected VisitAppointmentService $appointmentService;


    /**
     *
     */
    public ?int $employeeId = null;


    /**
     *
     */
    public ?array $employeeLicensePlates;


    /**
     *
     */
    public ?Collection $employees;


    /**
     *
     */
    public ?string $endDate;


    /**
     *
     */
    public ?array $endDates;


    /**
     *
     */
    public bool $isActive = true;


    /**
     *
     */
    protected LogService $logService;


    /**
     *
     */
    //  #[Validate('exists:license_plates,id')] // nullable|numeric|
    public ?array $selectedEmployeeLicensePlates;


    /**
     *
     */
    public ?string $startDate;


    /**
     *
     */
    public ?array $startDates;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function boot(LogService $logService, VisitAppointmentService $appointmentService)
    {
        $this->logService = $logService;
        $this->appointmentService = $appointmentService;

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    private function checkLicensePlateData(int $index)
    {
        $data = [
            "employeeId" => $this->employeeId,
            "startDates" => $this->startDates,
            "endDates" => $this->endDates,
        ];
        $validator = Validator::make($data, [
            'employeeId' => 'required|exists:employees,id',
            "startDates.$index" => 'required',
            "endDates.$index" => "required|after_or_equal:startDates.$index",
        ], [
            "startDates.$index.required" => 'You must select a start date.',
            "endDates.$index.required" => 'You must select an end date.',
        ])->validate();

    } // checkLicensePlateData()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function createAccessAuthorization()
    {
        if (isset($this->employeeId)) {
            $this->validate([
                'selectedEmployeeLicensePlates' => 'required',
            ]);
            foreach ($this->selectedEmployeeLicensePlates as $index => $value) {
                if ($value === true) {
                    $this->checkLicensePlateData($index);
                }
            }
        } else {
            $this->validate([
                'startDate' => 'required',
                'endDate' => 'required|after_or_equal:startDate',
                'licensePlates' => 'required',
            ]);
        }
        try {
            $accessAuthorizationToCreate = [
                'active' => $this->isActive,
                'visit_reason_id' => VisitReason::whereRelation('visitType', 'visit_types.identifier', VisitTypeIdentifier::AccessAuthorization->value)->first()->id,
                'checkin_permitted' => 1,
                'checkout_permitted' => 1,
                'drive_on_area_permitted' => 1,
                'require_escort' => 0,
                'with_minors' => 0,
            ];

            if (is_int($this->employeeId)) {
                foreach ($this->selectedEmployeeLicensePlates as $index => $isSelected) {
                    if ($isSelected === true) {
                        $employeeLicensePlate = $this->employeeLicensePlates[$index];

                        $accessAuthorizationToCreate['subject'] = $employeeLicensePlate;
                        $accessAuthorizationToCreate['license_plate_formatted'] = $employeeLicensePlate;

                        $accessAuthorizationToCreate['valid_from'] =  Carbon::parse($this->startDates[$index])->startOfDay();
                        $accessAuthorizationToCreate['valid_until'] = Carbon::parse($this->endDates[$index])->endOfDay();
                        $accessAuthorizationToCreate['main_employee_id'] = $this->employeeId;
                    }
                }
            } else {
                foreach ($this->licensePlates as $index => $licensePlate) {
                    $accessAuthorizationToCreate['subject'] = $licensePlate;
                    $accessAuthorizationToCreate['license_plate_formatted'] = $licensePlate;

                    $accessAuthorizationToCreate['valid_from'] =  Carbon::parse($this->startDate)->startOfDay();
                    $accessAuthorizationToCreate['valid_until'] = Carbon::parse($this->endDate)->endOfDay();
                }
            }
            $accessAuthorization = $this->appointmentService->create($accessAuthorizationToCreate);

            $this->logService->log(LogLevel::Info, "Access Authorization id: {$accessAuthorization->id} added by " . auth()->user()->name . ' (' . auth()->user()->email . ')');

            $this->dispatch('init-tippyjs');
            $this->dispatch('access-authorization-created');

        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'AccessAuthorizations/Modals/createAccessAuthorization error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when creating access authorization. Check the logs for more information.');
        }
    } // createAccessAuthorization()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function mount()
    {
        $this->employees = VisitEmployeeRepository::getAll();

    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function render()
    {
        return view('visitor-management::livewire.visit-access-authorizations.modals.create');

    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function updatedEmployeeId()
    {
        if(isset($this->employeeId))
        {
            $this->validate([
                'employeeId' => 'exists:employees,id',
            ]);
            $this->employeeLicensePlates = explode(';', VisitEmployee::findOrFail($this->employeeId)->license_plate) ?? [];
        }
    } // updatedEmployeeId()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function resetModal()
    {
        $this->employeeId = null;
        $this->selectedEmployeeLicensePlates = [];
        $this->startDates = [];
        $this->endDates = [];
        $this->employeeLicensePlates = [];
        $this->licensePlates = [];

    } // resetModal()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} //class Create extends Component {}
